% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksv.R
\name{generate_ksd}
\alias{generate_ksd}
\title{Generate Kernel Density Estimates (KDE) for Ks Distribution}
\usage{
generate_ksd(ks_df, bin_width = 0.01, maxK = 5)
}
\arguments{
\item{ks_df}{A data frame containing Ks values.}

\item{bin_width}{The width of each bin for KDE calculation.}

\item{maxK}{The maximum Ks value for the distribution.}
}
\value{
A list containing the following components:
\itemize{
\item \code{Ks}: A numeric vector representing the KDE values.
\item \code{bin_width}: The width of each bin used for KDE calculation.
\item \code{maxK}: The maximum Ks value for the distribution.
}
}
\description{
This function generates Kernel Density Estimates (KDE) for the Ks (synonymous substitution rates) distribution.
}
