% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.tree-conversion.R
\name{treeToJSON}
\alias{treeToJSON}
\title{Converts a data.tree to a JSON format}
\usage{
treeToJSON(
  tree,
  keepRoot = FALSE,
  topLevelSlots = c("default", "all"),
  createNewId = TRUE,
  pretty = FALSE
)
}
\arguments{
\item{tree}{the data.tree which should be parses}

\item{keepRoot}{logical. If \code{FALSE} (default) the root node from the tree
is pruned}

\item{topLevelSlots}{determines which slots should be moved to the top level of the 
node. If \code{default} or \code{NULL} slots 
\href{https://www.jstree.com/docs/json/}{used in the jsTree JSON} 
are kept on the top level, while any other atomic / list slots from the tree
are stored in an own slot called \sQuote{data}. If \code{all} *all* nodes are
stored on the top level. Alternatively, it can be an explicit vector of
slot names which should be kept. In the latter case it is the user's
responsibility to ensure that jsTree slots stay on the top level.}

\item{createNewId}{logical. If \code{TRUE} a new id will be generated. Any old \sQuote{id} 
will be stored in \sQuote{id.orig} and a warning will be issued, If \code{FALSE},
any existing id will be re-used.}

\item{pretty}{logical. If \code{TRUE} the resulting JSON is prettified}
}
\value{
a JSON string representing the data.tree
}
\description{
Walk through a \code{\link[data.tree]{data.tree}} and constructs a JSON string,
which can be rendered by shinyTree.
}
\details{
The JSON string generated follows the 
\href{https://www.jstree.com/docs/json/}{jsTree specifications}. In particular 
it encodes children nodes via the \sQuote{children} slot. 

All atomic or list slots of a node in the tree are stored in a data slot in 
the resulting JSON.

If the user wants to store some slots not in the data slot but on the top 
level of the node, parameter \code{topLevelSlots} can be used. This is useful
for additional parameters such as \sQuote{icon}, \sQuote{li_attr} or 
\sQuote{a_attr}, which jsTree expect to be on the top level of the node.

An example of how to make use of this functionality can be found in the
example folder of this library.
}
\section{Note}{

\code{\link{updateTree}} and \code{\link{renderTree}} need an unevaluated JSON 
string. Hence, this function returns a string rather than the JSON object itself.
}

\author{
Thorn Thaler, \email{thorn.thaler@thothal.at}
}
