% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timer.R
\name{updateShinyTimer}
\alias{updateShinyTimer}
\title{Update shinyTimer widget}
\usage{
updateShinyTimer(
  inputId,
  hours = NULL,
  minutes = NULL,
  seconds = NULL,
  type = NULL,
  label = NULL,
  background = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The input ID corresponding to the UI element.}

\item{hours}{The new starting time in hours for the countdown.}

\item{minutes}{The new starting time in minutes for the countdown.}

\item{seconds}{The new starting time in seconds for the countdown.}

\item{type}{The new type of the countdown timer display ("simple", "mm:ss",
"hh:mm:ss", "mm:ss.cs").}

\item{label}{The new label to be displayed above the countdown timer.}

\item{background}{The new shape of the timer's container ("none", "circle", "rectangle").}

\item{session}{The session object from the shiny server function.}
}
\value{
No return value, called for side effects.
}
\description{
Update shinyTimer widget
}
\examples{
if (interactive()) {
  library(shiny)
  shinyApp(
    ui = fluidPage(
      shinyTimer("timer", label = "Countdown Timer", seconds = 10, type = "mm:ss"),
      actionButton("update", "Update Timer")
    ),
    server = function(input, output, session) {
      observeEvent(input$update, {
        updateShinyTimer("timer", seconds = 20, type = "hh:mm:ss")
      })
    }
  )
}
}
