% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/layout.R
\name{spacer}
\alias{spacer}
\title{spacer}
\usage{
spacer(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI spacer component.
}
\description{
Spacer is a component used to add space between components.
}
\details{
\itemize{
\item \bold{x}. Type: \code{Space}. Default: \code{"1"}.
\item \bold{y}. Type: \code{Space}. Default: \code{"1"}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  card(card_body("Card 1")),
  spacer(y = 10),
  card(card_body("Card 2")),
  spacer(y = 2),
  card(card_body("Card 3")),
  spacer(y = 10),
  div(
    class = "flex",
    card(card_body("Card 4")),
    spacer(x = 5),
    card(card_body("Card 5")),
    spacer(x = 1),
    card(card_body("Card 6"))
  )
)

server <- function(input, output, session) {}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/layout/spacer}.
}
