% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/feedback.R
\name{popover}
\alias{popover}
\alias{popover_trigger}
\alias{popover_content}
\title{popover}
\usage{
popover(...)

popover_trigger(...)

popover_content(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI popover component.
}
\description{
Popover is a non-modal dialog that floats around its disclosure. It's commonly used for displaying additional rich content on top of something.
}
\details{
\itemize{
\item \bold{children*}. Type: \code{ReactNode[]}. Default: \code{NA}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"default"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{"lg"}.
\item \bold{shadow}. Type: \code{none OR sm OR md OR lg}. Default: \code{"lg"}.
\item \bold{backdrop}. Type: \code{transparent OR opaque OR blur}. Default: \code{"transparent"}.
\item \bold{placement}. Type: \code{PopoverPlacement}. Default: \code{"bottom"}.
\item \bold{state}. Type: \code{OverlayTriggerState}. Default: \code{NA}.
\item \bold{isOpen}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{defaultOpen}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{offset}. Type: \code{number}. Default: \code{"7"}.
\item \bold{containerPadding}. Type: \code{number}. Default: \code{"12"}.
\item \bold{crossOffset}. Type: \code{number}. Default: \code{"0"}.
\item \bold{triggerType}. Type: \code{dialog OR menu OR listbox OR tree OR grid}. Default: \code{"dialog"}.
\item \bold{showArrow}. Type: \code{boolean}. Default: \code{false}.
\item \bold{shouldFlip}. Type: \code{boolean}. Default: \code{true}.
\item \bold{triggerScaleOnOpen}. Type: \code{boolean}. Default: \code{true}.
\item \bold{shouldBlockScroll}. Type: \code{boolean}. Default: \code{false}.
\item \bold{shouldCloseOnScroll}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isKeyboardDismissDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{shouldCloseOnBlur}. Type: \code{boolean}. Default: \code{false}.
\item \bold{motionProps}. Type: \code{MotionProps}. Default: \code{NA}.
\item \bold{portalContainer}. Type: \code{HTMLElement}. Default: \code{"document.body"}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<'base' OR 'trigger' OR 'backdrop' OR 'content', string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onOpenChange}. Type: \code{(isOpen: boolean) => void}. Default: \code{NA}.
\item \bold{shouldCloseOnInteractOutside}. Type: \code{(e: HTMLElement) => void}. Default: \code{NA}.
\item \bold{onClose}. Type: \code{() => void}. Default: \code{NA}.
}
\itemize{
\item \bold{children*}. Type: \code{ReactNode}. Default: \code{NA}.
}
\itemize{
\item \bold{children}. Type: \code{ReactNode}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  dark_mode = TRUE,
  div(
    className = "flex align-items-start",
    popover(
      showArrow = TRUE,
      placement = "right",
      backdrop = "blur",
      popover_trigger(button("Click me!", color = "primary")),
      popover_content(
        div(
          className = "px-1 py-2",
          "This is the content of the popover."
        )
      )
    )
  )
)

server <- function(input, output, session) {
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/popover}.
}
