% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/layout.R
\name{navbar}
\alias{navbar}
\alias{navbar_brand}
\alias{navbar_content}
\alias{navbar_item}
\alias{navbar_toggle}
\title{navbar}
\usage{
navbar(...)

navbar_brand(...)

navbar_content(...)

navbar_item(...)

navbar_toggle(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI navbar component.
}
\description{
A responsive navigation header positioned on top side of your page that includes support for branding, links, navigation, collapse menu and more.
}
\details{
\itemize{
\item \bold{children*}. Type: \code{ReactNode[]}. Default: \code{NA}.
\item \bold{height}. Type: \code{string OR number}. Default: \code{"4rem (64px)"}.
\item \bold{position}. Type: \code{static OR sticky}. Default: \code{"sticky"}.
\item \bold{maxWidth}. Type: \code{sm OR md OR lg OR xl OR 2xl OR full}. Default: \code{"lg"}.
\item \bold{parentRef}. Type: \code{React.RefObject<HTMLElement>}. Default: \code{"window"}.
\item \bold{isBordered}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isBlurred}. Type: \code{boolean}. Default: \code{true}.
\item \bold{isMenuOpen}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isMenuDefaultOpen}. Type: \code{boolean}. Default: \code{false}.
\item \bold{shouldHideOnScroll}. Type: \code{boolean}. Default: \code{false}.
\item \bold{motionProps}. Type: \code{MotionProps}. Default: \code{NA}.
\item \bold{disableScrollHandler}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<'base' OR 'wrapper' OR 'brand' OR 'content' OR 'item' OR 'toggle' OR 'toggleIcon' OR 'menu' OR 'menuItem', string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onMenuOpenChange}. Type: \code{(isOpen: boolean) => void}. Default: \code{NA}.
\item \bold{onScrollPositionChange}. Type: \code{(position: number) => void}. Default: \code{NA}.
}
\itemize{
\item \bold{children*}. Type: \code{ReactNode[]}. Default: \code{NA}.
\item \bold{justify}. Type: \code{start OR center OR end}. Default: \code{"start"}.
}
\itemize{
\item \bold{children}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{isActive}. Type: \code{boolean}. Default: \code{false}.
}
\itemize{
\item \bold{icon}. Type: \code{ReactNode OR ((isOpen: boolean OR undefined) => ReactNode)}. Default: \code{NA}.
\item \bold{isSelected}. Type: \code{boolean}. Default: \code{false}.
\item \bold{defaultSelected}. Type: \code{boolean}. Default: \code{false}.
\item \bold{srOnlyText}. Type: \code{string}. Default: \code{"open/close navigation menu"}.
}
\itemize{
\item \bold{onChange}. Type: \code{(isOpen: boolean) => void}. Default: \code{NA}.
}
\itemize{
\item \bold{children*}. Type: \code{ReactNode[]}. Default: \code{NA}.
\item \bold{portalContainer}. Type: \code{HTMLElement}. Default: \code{"document.body"}.
\item \bold{motionProps}. Type: \code{MotionProps}. Default: \code{NA}.
}
\itemize{
\item \bold{children}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{isActive}. Type: \code{boolean}. Default: \code{false}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)
library(shiny.router)

sections <- c("main", "other")

layout <- function(..., content) {
  tags$div(
    css = JS("
      {
        maxW: '100\%',
        boxSizing: 'border-box',
      }"
    ),
    ..., # Navbar
    # Content
    tags$div(
      css = JS(
        "{
          boxSizing: 'border-box',
          px: '$12',
          mt: '$8',
          '@xsMax': {px: '$10'}
        }"
      ),
      content
    )
  )
}

# TO DO: create wrapper for end-user to simplify all this mess.
create_navbar <- function(id) {

  input <- get("input", envir = parent.frame())

  nav_links <- lapply(seq_along(sections), function(i) {
    # Li elements
    link(
      inputId = sprintf("link_\%s", i),
      href = route_link(sections[[i]]),
      key = i,
      value = i,
      parent = sprintf("navbar_\%s", sections[[i]]),
      isActive = if (is.null(input[[sprintf("navbar_\%s", id)]])) {
        if (i == 1) TRUE else FALSE
      } else {
        if (input[[sprintf("navbar_\%s", id)]] == i) TRUE else FALSE
      },
      sprintf("Link to \%s", sections[[i]])
    )
  })

  nav <- navbar(
    id = sprintf("navbar_\%s", id),
    maxWidth = "lg",
    variant = "floating",
    isBordered = TRUE,
    navbar_brand(p(b = TRUE, "Brand", color = "inherit", hideIn = "xs")),
    # Ul element
    navbar_content(
      variant = "highlight",
      activeColor = "success",
      nav_links,
      navbar_item(
        action_button(
          inputId = sprintf("navbar_button-\%s", id),
          "Click me",
          auto = TRUE,
          flat = TRUE
        )
      )
    )
  )

  if (is.null(input[[sprintf("navbar_\%s", id)]])) {
    tagList(
      tags$script(
        sprintf("Shiny.setInputValue('navbar_\%s', 0)", id)
      ),
      nav
    )
  } else {
    nav
  }
}

page <- function(id, content) {
  layout(
    reactOutput(sprintf("nav_\%s", id)),
    content = content
  )
}

home <- page(
  id = "main",
  card(
    numeric_input(
      inputId = "obs",
      label = "Number of observations:",
      value = 500
    ),
    plotOutput("distPlot")
  )
)
other <- page(
  id = "other",
  tableOutput('table')
)

ui <- nextui_page(
  router_ui(
    route("main", home),
    route("other", other)
  )
)

server <- function(input, output, session) {
  observe(print(input$navbar))
  output$nav_main <- renderReact({
    create_navbar("main")
  })

  output$nav_other <- renderReact({
    create_navbar("other")
  })

  output$distPlot <- renderPlot({
    hist(rnorm(input$obs))
  })
  output$table <- renderTable(iris)

  router_server("main")
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/navbar}.
}
