% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/feedback.R
\name{modal}
\alias{modal}
\alias{modal_content}
\alias{modal_header}
\alias{modal_body}
\alias{modal_footer}
\title{modal}
\usage{
modal(...)

modal_content(...)

modal_header(...)

modal_body(...)

modal_footer(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI modal component.
}
\description{
Displays a dialog with custom content that requires attention or provides additional information.
}
\details{
\itemize{
\item \bold{children*}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{size}. Type: \code{xs OR sm OR md OR lg OR xl OR 2xl OR 3xl OR 4xl OR 5xl OR full}. Default: \code{"md"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg}. Default: \code{"lg"}.
\item \bold{shadow}. Type: \code{none OR sm OR md OR lg}. Default: \code{"lg"}.
\item \bold{backdrop}. Type: \code{transparent OR opaque OR blur}. Default: \code{"opaque"}.
\item \bold{scrollBehavior}. Type: \code{normal OR inside OR outside}. Default: \code{"normal"}.
\item \bold{placement}. Type: \code{auto OR top OR center OR bottom}. Default: \code{"auto"}.
\item \bold{isOpen}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{defaultOpen}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{isDismissable}. Type: \code{boolean}. Default: \code{true}.
\item \bold{isKeyboardDismissDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{shouldBlockScroll}. Type: \code{boolean}. Default: \code{true}.
\item \bold{hideCloseButton}. Type: \code{boolean}. Default: \code{false}.
\item \bold{closeButton}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{motionProps}. Type: \code{MotionProps}. Default: \code{NA}.
\item \bold{portalContainer}. Type: \code{HTMLElement}. Default: \code{"document.body"}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<'wrapper' OR 'base' OR 'backdrop' OR 'header' OR 'body' OR 'footer' OR 'closeButton', string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onOpenChange}. Type: \code{(isOpen: boolean) => void}. Default: \code{NA}.
\item \bold{onClose}. Type: \code{() => void}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

ui <- nextui_page(
  action_button(
    inputId = "show_modal",
    color = "primary",
    shadow = TRUE,
    "Show modal"
  ),
  radio_input(
    "scroll",
    label = "Scroll option",
    choices = c(
      "inside" = "Inside",
      "outside" = "Outside"
    ),
    selected = "inside"
  ),
  reactOutput("modal")
)

server <- function(input, output, session) {
  modalVisible <- reactiveVal(FALSE)
  observeEvent(input$show_modal, {
    modalVisible(TRUE)
  })

  observeEvent(input$modal_closed, {
    modalVisible(FALSE)
  })

  output$modal <- renderReact({
    modal(
      scrollBehavior = input$scroll,
      isOpen = modalVisible(),
      size = "sm",
      modal_content(
        modal_header("My modal"),
        modal_body(
          p(
            "Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
            dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
            ac consectetur ac, vestibulum at eros."
          ),
          p(
            "Lorem ipsum dolor sit amet, consectetur adipiscing elit.
            Nullam pulvinar risus non risus hendrerit venenatis.
            Pellentesque sit amet hendrerit risus, sed porttitor quam.
            Magna exercitation reprehenderit magna aute tempor cupidatat
            consequat elit dolor adipisicing. Mollit dolor eiusmod sunt ex
            incididunt cillum quis. Velit duis sit officia eiusmod Lorem
            aliqua enim laboris do dolor eiusmod. Et mollit incididunt
            nisi consectetur esse laborum eiusmod pariatur proident Lorem
            eiusmod et. Culpa deserunt nostrud ad veniam."
          ),
          p(
            "Mollit dolor eiusmod sunt ex incididunt cillum quis. Velit
             duis sit officia eiusmod Lorem aliqua enim laboris do dolor
             eiusmod. Et mollit incididunt nisi consectetur esse laborum
             eiusmod pariatur proident Lorem eiusmod et. Culpa deserunt
             nostrud ad veniam. Lorem ipsum dolor sit amet, consectetur
             adipiscing elit. Nullam pulvinar risus non risus hendrerit
             venenatis. Pellentesque sit amet hendrerit risus, sed
             porttitor quam. Magna exercitation reprehenderit magna aute
             tempor cupidatat consequat elit dolor adipisicing. Mollit
             dolor eiusmod sunt ex incididunt cillum quis. Velit duis sit
             officia eiusmod Lorem aliqua enim laboris do dolor eiusmod. Et
             mollit incididunt nisi consectetur esse laborum eiusmod
             pariatur proident Lorem eiusmod et. Culpa deserunt nostrud ad
             veniam."
          ),
          p(
            "Mollit dolor eiusmod sunt ex incididunt cillum quis. Velit
             duis sit officia eiusmod Lorem aliqua enim laboris do dolor
             eiusmod. Et mollit incididunt nisi consectetur esse laborum
             eiusmod pariatur proident Lorem eiusmod et. Culpa deserunt
             nostrud ad veniam. Lorem ipsum dolor sit amet, consectetur
             adipiscing elit. Nullam pulvinar risus non risus hendrerit
             venenatis. Pellentesque sit amet hendrerit risus, sed
             porttitor quam. Magna exercitation reprehenderit magna aute
             tempor cupidatat consequat elit dolor adipisicing. Mollit
             dolor eiusmod sunt ex incididunt cillum quis. Velit duis sit
             officia eiusmod Lorem aliqua enim laboris do dolor eiusmod. Et
             mollit incididunt nisi consectetur esse laborum eiusmod
             pariatur proident Lorem eiusmod et. Culpa deserunt nostrud ad
             veniam."
          )
        ),
        modal_footer("Modal footer")
      ),
      onClose = JS("() => Shiny.setInputValue('modal_closed', true, {priority: 'event'})")
    )
  })

  exportTestValues(
    modal_state = modalVisible()
  )
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/modal}.
}
