% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/doc.R
\name{link}
\alias{link}
\title{link}
\usage{
link(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI link component.
}
\description{
Links allow users to click their way from page to page. This component is styled to resemble a hyperlink and semantically renders an <a>
}
\details{
\itemize{
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{color}. Type: \code{foreground OR primary OR secondary OR success OR warning OR danger}. Default: \code{"primary"}.
\item \bold{underline}. Type: \code{none OR hover OR always OR active OR focus}. Default: \code{"none"}.
\item \bold{href}. Type: \code{string}. Default: \code{NA}.
\item \bold{target}. Type: \code{HTMLAttributeAnchorTarget}. Default: \code{NA}.
\item \bold{rel}. Type: \code{string}. Default: \code{NA}.
\item \bold{download}. Type: \code{boolean OR string}. Default: \code{NA}.
\item \bold{ping}. Type: \code{string}. Default: \code{NA}.
\item \bold{referrerPolicy}. Type: \code{HTMLAttributeReferrerPolicy}. Default: \code{NA}.
\item \bold{isExternal}. Type: \code{boolean}. Default: \code{false}.
\item \bold{showAnchorIcon}. Type: \code{boolean}. Default: \code{false}.
\item \bold{anchorIcon}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{isBlock}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
}
\itemize{
\item \bold{onPress}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressStart}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressEnd}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onPressChange}. Type: \code{(isPressed: boolean) => void}. Default: \code{NA}.
\item \bold{onPressUp}. Type: \code{(e: PressEvent) => void}. Default: \code{NA}.
\item \bold{onKeyDown}. Type: \code{(e: KeyboardEvent) => void}. Default: \code{NA}.
\item \bold{onKeyUp}. Type: \code{(e: KeyboardEvent) => void}. Default: \code{NA}.
\item \bold{onClick}. Type: \code{MouseEventHandler}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)

colors <- c(
  "default",
  "primary",
  "secondary",
  "success",
  "warning",
  "error"
)

link_config <- data.frame(
  color = colors,
  underline = c(rep("none", 2), "hover", "always", "active", "focus"),
  block = c(rep(TRUE, 3), rep(FALSE, 3)),
  href = c(rep("#", 3), rep("https://google.com", 3)),
  isExternal = c(rep(FALSE, 3), rep(TRUE, 3)),
  size = rep(c("sm", "md", "lg"), 2)
)

link_factory <- function(color, underline, block, href, isExternal, size) {
  link(
    "A super link!",
    color = color,
    underline = underline,
    isBlock = block,
    href = href,
    isExternal = isExternal,
    size = size
  )
}

links <- purrr::pmap(link_config, link_factory)

ui <- nextui_page(
  div(
    class = "grid gap-4 grid-cols-3 grid-rows-2 m-5",
    links
  )
)

server <- function(input, output, session) {}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/link}.
}
