% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/doc.R
\name{avatar}
\alias{avatar}
\alias{avatar_group}
\title{avatar}
\usage{
avatar(...)

avatar_group(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI avatar component.
}
\description{
The Avatar component is used to represent a user, and displays the profile picture, initials or fallback icon.
}
\details{
\itemize{
\item \bold{src}. Type: \code{string}. Default: \code{NA}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"default"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{"full"}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{name}. Type: \code{string}. Default: \code{NA}.
\item \bold{icon}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{fallback}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{isBordered}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isFocusable}. Type: \code{boolean}. Default: \code{false}.
\item \bold{showFallback}. Type: \code{boolean}. Default: \code{false}.
\item \bold{ImgComponent}. Type: \code{React.ElementType}. Default: \code{"img"}.
\item \bold{imgProps}. Type: \code{ImgComponentProps}. Default: \code{NA}.
\item \bold{classNames}. Type: \code{Partial<Record<"base" OR "img" OR "fallback" OR "name" OR "icon", string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{max}. Type: \code{number}. Default: \code{"5"}.
\item \bold{total}. Type: \code{number}. Default: \code{NA}.
\item \bold{size}. Type: \code{AvatarProps['size']}. Default: \code{NA}.
\item \bold{color}. Type: \code{AvatarProps['color']}. Default: \code{NA}.
\item \bold{radius}. Type: \code{AvatarProps['radius']}. Default: \code{NA}.
\item \bold{isGrid}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{isBordered}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{renderCount}. Type: \code{(count: number) => ReactNode}. Default: \code{NA}.
\item \bold{classNames}. Type: \code{Partial<Record<"base" OR "count", string>>}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)

avatar_config <- data.frame(
  size = c("xs", "sm", "md", "lg", "xl"),
  src = c(
    "https://i.pravatar.cc/150?u=a042581f4e29026024d",
    "https://i.pravatar.cc/150?u=a042581f4e29026704d",
    "https://i.pravatar.cc/150?u=a04258114e29026702d",
    "https://i.pravatar.cc/150?u=a048581f4e29026701d",
    "https://i.pravatar.cc/150?u=a092581d4ef9026700d"
  ),
  radius = c(rep("full", 2), "lg", "md", "sm"),
  disabled = c(rep(FALSE, 4), TRUE),
  bordered = c(rep(TRUE, 3), rep(FALSE, 2)),
  color = c(
    "primary",
    "secondary",
    "danger",
    "success",
    "warning"
  ),
  fallback = rep(TRUE, 5)
)

avatar_factory <- function(src, size, disabled, bordered, radius, color, fallback) {
  avatar(
    src = src,
    size = size,
    isDisabled = disabled,
    isBordered = bordered,
    radius = radius,
    color = color,
    showFallback = fallback
  )
}

avatars <- purrr::pmap(avatar_config, avatar_factory)

ui <- nextui_page(
  debug_react = TRUE,
  class = "container mx-auto px-4",
  p("avatar()"),
  spacer(y = 1),
  div(
    class = "flex gap-3 items-center",
    avatars
  ),
  spacer(y = 2),
  p("avatar_group()"),
  spacer(y = 1),
  div(
    class = "flex",
    avatar_group(
      isBordered = TRUE,
      max = 3,
      total = 10,
      lapply(avatar_config$src, function(link) avatar(src = link))
    )
  )
)

server <- function(input, output, session) {}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/avatar}.
}
