% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setBlur.R
\name{setBlur}
\alias{setBlur}
\title{Custom blur animation}
\usage{
setBlur(intensity = 2)
}
\arguments{
\item{intensity}{Blur intensity.}
}
\description{
Allow to apply a blur effect on a given element.
}
\examples{
 if (interactive()) {

  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)
  library(shinyEffects)

  boxTag <- box(
   title = "A box",
   status = "warning",
   solidHeader = FALSE,
   collapsible = TRUE,
   p("Box Content")
  )

  shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(
      setBlur(),
      fluidRow(blurContainer(boxTag), boxTag)
     ),
     controlbar = dashboardControlbar(),
     title = "DashboardPage"
   ),
   server = function(input, output) { }
  )
}
}
