% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsheet_connector.R
\docType{class}
\name{RegLogGsheetConnector}
\alias{RegLogGsheetConnector}
\title{Connector to googlesheet database}
\description{
Object of this class handles all connections for the RegLogServer
object to the database. It is created to handle googlesheet database.
Provides methods than will be used by RegLogServer to get and send data.

Requires \code{googlesheets4} package to be installed.
}
\seealso{
Other dbConnectors: 
\code{\link{RegLogDBIConnector}}
}
\concept{dbConnectors}
\section{Super class}{
\code{\link[shiny.reglog:RegLogConnector]{shiny.reglog::RegLogConnector}} -> \code{RegLogGsheetConnector}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RegLogGsheetConnector-new}{\code{RegLogGsheetConnector$new()}}
\item \href{#method-RegLogGsheetConnector-clone}{\code{RegLogGsheetConnector$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shiny.reglog" data-topic="RegLogConnector" data-id="get_logs"><a href='../../shiny.reglog/html/RegLogConnector.html#method-RegLogConnector-get_logs'><code>shiny.reglog::RegLogConnector$get_logs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.reglog" data-topic="RegLogConnector" data-id="resume"><a href='../../shiny.reglog/html/RegLogConnector.html#method-RegLogConnector-resume'><code>shiny.reglog::RegLogConnector$resume()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.reglog" data-topic="RegLogConnector" data-id="suspend"><a href='../../shiny.reglog/html/RegLogConnector.html#method-RegLogConnector-suspend'><code>shiny.reglog::RegLogConnector$suspend()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RegLogGsheetConnector-new"></a>}}
\if{latex}{\out{\hypertarget{method-RegLogGsheetConnector-new}{}}}
\subsection{Method \code{new()}}{
Initialization of the object. Creates initial connection
to the database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogGsheetConnector$new(
  gsheet_ss,
  gsheet_sheetnames = c("account", "reset_code", "logs"),
  custom_handlers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gsheet_ss}}{id of the googlesheet holding database}

\item{\code{gsheet_sheetnames}}{character vector. Contains names of the sheets in the
googlesheet: first containing user data, second - reset codes information,
third (optional) - logs from the object. For more info check documentation
of \code{gsheet_database_create}.}

\item{\code{custom_handlers}}{named list of custom handler functions. Every
custom handler should take arguments: \code{self} and \code{private} - relating
to the R6 object and \code{message} of class \code{RegLogConnectorMessage}. It
should return \code{RegLogConnectorMessage} object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object of \code{RegLogDBIConnector} class
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RegLogGsheetConnector-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RegLogGsheetConnector-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RegLogGsheetConnector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
