% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jdatetime.R
\name{jdatetime}
\alias{jdatetime}
\alias{jdatetime.character}
\title{Date-time based on the Jalali calendar}
\usage{
jdatetime(x, tzone = "", ...)

\method{jdatetime}{character}(x, tzone = "", format = NULL, ..., ambiguous = NULL)
}
\arguments{
\item{x}{A vector of numeric or character objects.}

\item{tzone}{A time zone name. Default value represents local time zone.}

\item{...}{Arguments passed on to further methods.}

\item{format}{Format argument for character method.}

\item{ambiguous}{Resolve ambiguous times that occur during a repeated interval
(when the clock is adjusted backwards during the transition from DST to standard time).
Possible values are:
\itemize{
\item \code{"earliest"}: Choose the earliest of the two moments.
\item \code{"latest"}: Choose the latest of the two moments.
\item \code{"NA"}: Produce \code{NA}.
}

If \code{NULL}, defaults to \code{"earliest"}; as this seems to be base R's behavior.}
}
\value{
A vector of \code{jdatetime} objects.
}
\description{
\code{jdatetime} is an S3 class for representing date-times with the Jalali calendar dates.
It can be constructed from character and numeric vectors.
}
\details{
\code{jdatetime} is stored internally as a double vector and has a single
attribute: the timezone (tzone). Its value represents the count of seconds
since the Unix epoch (a negative value if it represents an instant prior to the epoch).
This implementation coincides with that of \code{POSIXct} class, except that \code{POSIXct}
may not have \code{tzone} attribute. But for \code{jdatetime}, \code{tzone} is not optional.
}
\examples{
## default time zone and format
jdatetime("1402-09-20 18:57:09")
jdatetime("1402/09/20 18:57:09", tzone = "UTC", format = "\%Y/\%m/\%d \%H:\%M:\%S")
## Will replace invalid format with NA
jdatetime("1402/09/20 18:57:09", format = "\%Y-\%m-\%d \%H:\%M:\%S")
## nonexistent time will be replaced with NA
jdatetime("1401-01-02 00:30:00", tzone = "Asia/Tehran")
## ambiguous time will be replaced with NA
jdatetime("1401-06-30 23:30:00", tzone = "Asia/Tehran", ambiguous = "NA")
## ambiguous time will resolve by choosing the later time instant
jdatetime("1401-06-30 23:30:00", tzone = "Asia/Tehran", ambiguous = "latest")
## Jalali date-time in Iran time zone, corresponding to Unix epoch
jdatetime(0, "Iran")
}
