% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h2o.get_ids.R
\name{h2o.get_ids}
\alias{h2o.get_ids}
\title{h2o.get_ids}
\usage{
h2o.get_ids(automl)
}
\arguments{
\item{automl}{a h2o \code{"AutoML"} grid object}
}
\value{
a character vector of trained models' names (IDs)
}
\description{
extracts the model IDs from H2O AutoML object or H2O grid
}
\examples{

\dontrun{
library(h2o)
h2o.init(ignore_config = TRUE, nthreads = 2, bind_to_localhost = FALSE, insecure = TRUE)
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(path = prostate_path, header = TRUE)
y <- "CAPSULE"
prostate[,y] <- as.factor(prostate[,y])  #convert to factor for classification
aml <- h2o.automl(y = y, training_frame = prostate, max_runtime_secs = 30)

# get the model IDs
ids <- h2o.ids(aml)
}
}
\author{
E. F. Haghish
}
