% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeR.R
\name{detect.outline}
\alias{detect.outline}
\title{Detect otolith outline}
\usage{
detect.outline(object, threshold=0.2, mouse.click=FALSE,
           display.images=FALSE, write.outline.w.org=FALSE)
}
\arguments{
\item{object}{\code{\linkS4class{shapeR}} object}

\item{threshold}{Grayscale threshold. Value between 0 and 1.}

\item{mouse.click}{If TRUE, the user clicks where the starting point for the otolith contour extraction algorithm should start. Default is the center of the image. Could be good to set as TRUE if the otolith detection produces an error.}

\item{display.images}{If TRUE, each image is displayed and the user can visualize how the outline is captured}

\item{write.outline.w.org}{If TRUE, the outline is written on top of the original image using the function \code{\link{write.image.with.outline}}, and can be seen in the \code{Original_with_outline} folder}
}
\value{
A \code{\linkS4class{shapeR}} object with otolith outlines in the slot outline.list
}
\description{
Determine the outline of otolith images in jpeg format which have been stored in the \code{Fixed} folder.
}
\details{
Based on the Conte function (Claude 2008)
}
\examples{
\dontrun{
#Use test data from Libungan and Palsson (2015):
shape = shapeR("ShapeAnalysis/","FISH.csv")
shape = detect.outline(shape, threshold=0.2,write.outline.w.org = TRUE)}
}
\references{
Claude, J. (2008). Morphometrics with R. Springer. 316 p.

Urbanek, S. (2014). \code{\link{jpeg}}: Read and write JPEG images. R package  version 0.1-8.

Bivand, R., Leisch, F. & Maechler, M. (2011) {pixmap}: Bitmap Images (''Pixel Maps''). R package version 0.4-11.

Libungan LA and Palsson S (2015) ShapeR: An R Package to Study Otolith Shape Variation among Fish Populations. PLoS ONE 10(3): e0121102. \url{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0121102}
}
\author{
Lisa Anne Libungan & Snaebjorn Palsson
}
