% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgo_transform.R
\encoding{UTF-8}
\name{sgo_transform}
\alias{sgo_transform}
\title{Coordinate transformation of a set of points}
\usage{
sgo_transform(x, to = NULL, ...)
}
\arguments{
\item{x}{A \code{sgo_points} object.}

\item{to}{Specifies the EPSG code to convert the coordinates to. See
\code{\link{sgo_points}} for a list of supported EPSG codes.}

\item{...}{Additional parameters passed to internal functions. Currently it
supports the additional arguments seen in \code{sgo_bng_lonlat} and
\code{sgo_lonlat_bng}.}
}
\value{
An object of class 'sgo_points'.
}
\description{
Transforms the coordinate system of a set of points to any supported
coordinate system.
}
\details{
This function is a wrapper of specific transformation functions
(\code{\link{sgo_bng_lonlat}}, \code{\link{sgo_en_wgs84}},
\code{\link{sgo_lonlat_bng}}, \code{\link{sgo_wgs84_en}},
\code{\link{sgo_laea_etrs}}, \code{\link{sgo_etrs_laea}},
\code{\link{sgo_cart_lonlat}}, \code{\link{sgo_lonlat_cart}}) that transforms
the coordinate system of a set of points to any of the supported coordinate
systems.

Please note that this package assumes that the Coordinate Reference Systems
(CRS) ETRS89 and WGS84 are the same within the UK, but this shouldn't be a
problem for most civilian use of GPS satellites. If a high-precision
transformation between WGS84 and ETRS89 is required then it is recommended
to use a different package to do the conversion.

According to the Transformations and OSGM15 User Guide, p. 8:
\emph{"...ETRS89 is a precise version of the better known WGS84 reference
system optimised for use in Europe; however, for most purposes it can be
considered equivalent to WGS84."} and \emph{"For all navigation, mapping,
GIS, and engineering applications within the tectonically stable parts of
Europe (including UK and Ireland), the term ETRS89 should be taken as
synonymous with WGS84."}.

\strong{Warning: }Coordinates defined in the Geodetic Coordinate System
EPSG:4277 (with datum OSGB 1936) should only be used to convert to or from
BNG coordinates and for historical reasons only.
}
\examples{
ln <- c(-4.22472, -2.09908)
lt <- c(57.47777, 57.14965)
n <- c("Inverness", "Aberdeen")
df <- data.frame(n, ln, lt, stringsAsFactors = FALSE)
locations <- sgo_points(df, coords=c("ln", "lt"), epsg=4326)

locations.bng <- sgo_transform(locations, to=27700)
locations.osgb36 <- sgo_transform(locations, to=4277)
locations.ngr <- sgo_bng_ngr(sgo_transform(locations, to=27700))
locations.wgs84EN <- sgo_transform(locations.bng, to=3857)
}
\seealso{
\code{\link{sgo_points}}, \code{\link{sgo_coordinates}},
\code{\link{sgo_set_gcs}}, \code{\link{sgo_bng_ngr}}
}
