% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_growth_model.R
\name{sgmodel}
\alias{sgmodel}
\title{Sgmodel}
\usage{
sgmodel(grid, utiltype, utilparam, A, depre, discount, prod, states, m, rho,
  sigma, ...)
}
\arguments{
\item{grid}{A numerical value, the number of capital grid points to consider for k (t). Default value set to 1000.}

\item{utiltype}{The type of preference for the \code{util} function. Can be "log", "CRRA", "CARA", "Cobb-Douglas", "CES". See description of \code{util} for details. Default type set to "log".}

\item{utilparam}{Numerical value, preference parameter for the \code{util} function. See description of \code{util} for details. Default set to 1.}

\item{A}{Numerical value, preference parameter for the \code{util} function. See description of \code{util} for details. Default set to 1.}

\item{depre}{Numerical value for the depreciation parameter. Must be between 0 and 1. Default value set to 1.}

\item{discount}{Numerical value for the discount factor. Must be (strictly) between 0 and 1. Default value set to 0.95.}

\item{prod}{Numerical value for the Cobb-Douglas production function. Must be (strictly) between 0 and 1. Default value set to 0.3.}

\item{states}{umerical value for the number of states of the Markov process approximating the TFP process. Default value set to 2.}

\item{m}{Numerical value for the \code{Rtauchen} function. See description of \code{Rtauchen} for details. Default value set to 3.}

\item{rho}{Autocorrelation of the TFP AR(1) process, used to approximate the process with a Markov process.}

\item{sigma}{Standard deviation of the white noise in the TFP process, used to approximate the process with a Markov process.}

\item{...}{Additional arguments.}
}
\value{
The function returns a list containing:
\item{Capital grid }{Vector of values for capital.}
\item{Savings }{ Vector of size (\code{grid} x \code{States}) indicating which coordinates of the capital grid are the optimal savings decision.}
\item{Consumption }{Vector of size (\code{grid} x \code{States}) indicating the optimal consumption decisions using the optimal savings decision, and given the capital level of the corresponding coordinate of \code{Capital grid}.}
\item{Z }{States of the TFP process.}
\item{PTM }{The probability transition matrix of the process.}
\item{Production parameter }{The exponent on capital in the Cobb-Douglas production function.}
\item{Utility type }{The type of utility function. See the details of "util" for the available types}
\item{Discount factor }{The discount factor used in the model.}
\item{Depreciation }{The depreciation rate of capital used in the model.}
\item{Rho }{Autocorrelation of the TFP AR(1) process.}
\item{Sigma }{Standard deviation of the white noise in the TFP process.}
}
\description{
The function \code{sgmodel} computes the solutions to a generic stochastic growth model after discretizing the distribution of the stochastic element.
}
\examples{
model <- sgmodel(grid= 100, rho = 0.2, sigma = 0.02)

grid <- 200
utiltype <- "CRRA"
utilparam <- 4
A <- 1
depre <- 0.03
discount <- 0.95
prod <- 0.3
states <- 5
m <- 10
rho <- 0.2
sigma <- 0.02
model <- sgmodel(grid, utiltype, utilparam, A, depre, discount, prod, states, m, rho, sigma)
}
\references{
Tauchen G (1986), Finite state markov-chain approximations to univariate and vector autoregressions.
\emph{Economics letters}, \bold{20}(2), 177--181.

Merton R. C (1971), Optimum consumption and portfolio rules in a continuous-time model.
\emph{Journal of Economic Theory}, \bold{3}(4), 373--413.
URL \url{https://www.sciencedirect.com/science/article/pii/002205317190038X}
}
