% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-set-operations.R
\name{nb_union}
\alias{nb_union}
\alias{nb_intersect}
\alias{nb_setdiff}
\title{Set Operations}
\usage{
nb_union(x, y)

nb_intersect(x, y)

nb_setdiff(x, y)
}
\arguments{
\item{x}{list of class \code{nb}}

\item{y}{list of class \code{nb}}
}
\value{
A list of class \code{nb}
}
\description{
Perform set operations element-wise on two lists of equal length.
}
\details{
\itemize{
\item \code{nb_union()} returns the union of elements in each element of x and y
\item \code{nb_intersect()} returns the intersection of elements in each element of x and y
\item \code{nb_setdiff()} returns the difference of elements in each element of x and y
}
}
\examples{
nb <- st_contiguity(guerry$geometry)
nb_knn <- st_knn(guerry$geometry, k = 3)
nb_setdiff(nb, nb_knn)
nb_union(nb, nb_knn)
nb_intersect(nb, nb_knn)

}
