% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc_rules.R
\name{sfc_expand_by_rules,sfc_rules,sfc_nxn-method}
\alias{sfc_expand_by_rules,sfc_rules,sfc_nxn-method}
\alias{sfc_expand_by_rules}
\alias{sfc_expand_by_rules,sfc_rules,factor-method}
\alias{sfc_expand_by_rules,sfc_rules,character-method}
\title{Expand a sequence}
\usage{
\S4method{sfc_expand_by_rules}{sfc_rules,sfc_nxn}(p, seq, code = 1L, flip = FALSE, by = "Cpp")

\S4method{sfc_expand_by_rules}{sfc_rules,factor}(p, seq, code = 1L, flip = FALSE, by = "Cpp")

\S4method{sfc_expand_by_rules}{sfc_rules,character}(p, seq, code = 1L, flip = FALSE, by = "Cpp")
}
\arguments{
\item{p}{An \code{sfc_rules} object.}

\item{seq}{An \code{sfc_nxn} object or other objects.}

\item{code}{The expansion code.}

\item{flip}{For the Peano curve and the Meander curves, each unit can be flipped without affecting other parts in the curve. This argument
controls whether to flip the unit. Since currently it only works on the Peano curve and the Meander curve, \code{flip} should be a logical
vector of length one or with the same length as \code{seq}. Whether it flips horizontally, vertically or against the diagonal line is automatically choosen.
The value of \code{flip} can also be a function which takes the current curve as the only argument.}

\item{by}{Which implementation? Only for the testing purpose.}
}
\value{
If \code{seq} is an \code{sfc_nxn} object, the function also returns an "expanded" \code{sfc_nxn} object. Or else it returns an \code{sfc_sequence} object.
}
\description{
Expand a sequence
}
\examples{
sfc_expand_by_rules(SFC_RULES_2x2, sfc_2x2("I"))
}
