% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-user.R
\name{User}
\alias{User}
\title{R6 Class Representing a platform User}
\description{
User object containing user information.
}
\details{
This is the main object for Users.
}
\section{Super class}{
\code{\link[sevenbridges2:Item]{sevenbridges2::Item}} -> \code{User}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}

\item{\code{username}}{User name.}

\item{\code{email}}{User's email address.}

\item{\code{first_name}}{User's first name.}

\item{\code{last_name}}{User's last name.}

\item{\code{affiliation}}{The company or the institute the user is affiliated
with.}

\item{\code{phone}}{User's phone number.}

\item{\code{address}}{User's residential address.}

\item{\code{city}}{User's city of residence.}

\item{\code{state}}{User's state of residence.}

\item{\code{country}}{User's country of residence.}

\item{\code{zip_code}}{Zip code for the user's residence.}

\item{\code{role}}{User's role.}

\item{\code{tags}}{Platform tags associated with the user.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-User-new}{\code{User$new()}}
\item \href{#method-User-print}{\code{User$print()}}
\item \href{#method-User-reload}{\code{User$reload()}}
\item \href{#method-User-clone}{\code{User$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-User-new"></a>}}
\if{latex}{\out{\hypertarget{method-User-new}{}}}
\subsection{Method \code{new()}}{
Create a new User object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{User$new(res = NA, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{Response containing User object information.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-User-print"></a>}}
\if{latex}{\out{\hypertarget{method-User-print}{}}}
\subsection{Method \code{print()}}{
Print user information as bullet list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{User$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-User-reload"></a>}}
\if{latex}{\out{\hypertarget{method-User-reload}{}}}
\subsection{Method \code{reload()}}{
Reload User object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{User$reload(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{User}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-User-clone"></a>}}
\if{latex}{\out{\hypertarget{method-User-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{User$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
