% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-import.R
\name{Import}
\alias{Import}
\title{R6 Class representing an Import job}
\description{
R6 Class representing a resource for managing volume import jobs.
}
\examples{

## ------------------------------------------------
## Method `Import$print`
## ------------------------------------------------

\dontrun{
 # x is API response when import is requested
 import_object <- Import$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print import object
 import_object$print()
}


## ------------------------------------------------
## Method `Import$reload`
## ------------------------------------------------

\dontrun{
 # x is API response when import is requested
 import_object <- Import$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload import object
 import_object$reload()
}

}
\section{Super class}{
\code{\link[sevenbridges2:Item]{sevenbridges2::Item}} -> \code{Import}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}

\item{\code{id}}{Import job string identifier.}

\item{\code{state}}{The state of the import job. Possible values are:
\itemize{
\item \code{PENDING}: the import is queued;
\item \code{RUNNING}: the import is running;
\item \code{COMPLETED}: the import has completed successfully;
\item \code{FAILED}: the import has failed.
}}

\item{\code{overwrite}}{Indicates whether the imported file or folder name
was overwritten if another with the same name already existed.}

\item{\code{autorename}}{Indicates whether the imported file or folder name
was automatically renamed (by prefixing its name with an underscore
and number) if another with the same name already existed.}

\item{\code{preserve_folder_structure}}{Whether the imported folder
structure was preserved or not.}

\item{\code{source}}{List containing source volume id and source location of
the file/folder is being imported to the platform.}

\item{\code{destination}}{List containing the source volume ID and the source
location of the file or folder being imported to the platform.}

\item{\code{started_on}}{Time when the import job started.}

\item{\code{finished_on}}{Time when the import job ended.}

\item{\code{error}}{In case of error in the import job, standard API error is
returned here.}

\item{\code{result}}{File object that was imported.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Import-new}{\code{Import$new()}}
\item \href{#method-Import-print}{\code{Import$print()}}
\item \href{#method-Import-reload}{\code{Import$reload()}}
\item \href{#method-Import-clone}{\code{Import$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Import-new"></a>}}
\if{latex}{\out{\hypertarget{method-Import-new}{}}}
\subsection{Method \code{new()}}{
Create a new Import object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Import$new(res = NA, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{Response containing Import object information.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Import-print"></a>}}
\if{latex}{\out{\hypertarget{method-Import-print}{}}}
\subsection{Method \code{print()}}{
Print method for Import class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Import$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when import is requested
 import_object <- Import$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print import object
 import_object$print()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Import-reload"></a>}}
\if{latex}{\out{\hypertarget{method-Import-reload}{}}}
\subsection{Method \code{reload()}}{
Reload Import object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Import$reload(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Import}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when import is requested
 import_object <- Import$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload import object
 import_object$reload()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Import-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Import-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Import$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
