% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{check_globalenv_objects}
\alias{check_globalenv_objects}
\title{Check global environment objects}
\usage{
check_globalenv_objects(action = "warn", allow_globalenv_objects = NULL)
}
\arguments{
\item{action}{Behaviour to take if the status is not clean. Possible values are
"error", "warn", "message", and "none". The default is \code{action = "warn"}.}

\item{allow_globalenv_objects}{Character vector containing names of objects
that are "allowed", and will not trigger an action.}
}
\value{
Invisibly returns an object of class \code{sessioncheck_status}.
}
\description{
Individual session check functions that inspect the contents of the global
environment and the names of attached non-package environments. Session checkers
can produce errors, warnings, or messages if requested.
}
\details{
This checker inspects the state of the global environment and takes action based
on the objects found there. When \code{allow_globalenv_objects = NULL}, variables
in the global environment will not trigger an action if the name starts with a dot.
For example, \code{.Random.seed} and \code{.Last.value} do not trigger actions by default.
}
\examples{
check_globalenv_objects(action = "message")
 
}
\seealso{
\code{\link[=check_attached_packages]{check_attached_packages()}},
\code{\link[=check_loaded_namespaces]{check_loaded_namespaces()}},
\code{\link[=check_globalenv_objects]{check_globalenv_objects()}},
\code{\link[=check_attached_environments]{check_attached_environments()}},
\code{\link[=check_sessiontime]{check_sessiontime()}},
\code{\link[=check_required_options]{check_required_options()}},
\code{\link[=check_required_locale]{check_required_locale()}},
\code{\link[=check_required_sysenv]{check_required_sysenv()}}
}
