% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{check_attached_environments}
\alias{check_attached_environments}
\title{Check environments attached to the search path}
\usage{
check_attached_environments(
  action = "warn",
  allow_attached_environments = NULL
)
}
\arguments{
\item{action}{Behaviour to take if the status is not clean. Possible values are
"error", "warn", "message", and "none". The default is \code{action = "warn"}.}

\item{allow_attached_environments}{Character vector containing names of environments
that are "allowed", and will not trigger an action if attached to the search path.}
}
\value{
Invisibly returns an object of class \code{sessioncheck_status}.
}
\description{
Individual session check function that inspects the names of attached non-package
environments. Session checkers can produce errors, warnings, or messages if requested.
}
\details{
This checker inspects all environments on the search path. This includes attached
packages, anything added using \code{attach()}, and the global environment. When
\code{allow_attached_environments = NULL}, package environents do not trigger an
action, nor do "tools:rstudio", "tools:positron", "tools:callr", or "Autoloads".
The global environment and the package environment for the \strong{base} package
never trigger actions.
}
\examples{
check_attached_environments(action = "message")
 
}
\seealso{
\code{\link[=check_attached_packages]{check_attached_packages()}},
\code{\link[=check_loaded_namespaces]{check_loaded_namespaces()}},
\code{\link[=check_globalenv_objects]{check_globalenv_objects()}},
\code{\link[=check_attached_environments]{check_attached_environments()}},
\code{\link[=check_sessiontime]{check_sessiontime()}},
\code{\link[=check_required_options]{check_required_options()}},
\code{\link[=check_required_locale]{check_required_locale()}},
\code{\link[=check_required_sysenv]{check_required_sysenv()}}
}
