% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomial_models.R
\name{farrington_model}
\alias{farrington_model}
\title{The Farrington (1990) model.}
\usage{
farrington_model(data, start, fixed = list())
}
\arguments{
\item{data}{the input data frame, must either have `age`, `pos`, `tot` columns (for aggregated data) OR `age`, `status` for (linelisting data)}

\item{start}{Named list of vectors or single vector.
Initial values for optimizer.}

\item{fixed}{Named list of vectors or single vector.
Parameter values to keep fixed during optimization.}
}
\value{
a list of class farrington_model with 5 items
  \item{datatype}{type of datatype used for model fitting (aggregated or linelisting)}
  \item{df}{the dataframe used for fitting the model}
  \item{info}{fitted "glm" object}
  \item{sp}{seroprevalence}
  \item{foi}{force of infection}
}
\description{
Refers to section 6.1.2.
}
\examples{
df <- rubella_uk_1986_1987
model <- farrington_model(
  df,
  start=list(alpha=0.07,beta=0.1,gamma=0.03)
  )
plot(model)

}
\seealso{
[stats::glm()] for more information on the fitted glm object
}
