#' Venezuelan Equine Encephalitis Virus (VEEV) seroprevalence data in serofoi
#'
#' Datasets that measure the seroprevalence of IgG antibodies against VEEV in
#' a rural village in Panamá in 2012
#' [[Carrera2020](https://europepmc.org/article/med/33124532)].
#'
#' @docType data
#'
#' @usage data(veev2012)
#'
#' @format ## `veev2012`
#' A `<data.frame>` with 4 rows and 5 columns:
#' \describe{
#'   \item{survey_year}{Year in which the serosurvey was conducted}
#'   \item{n_sample}{Number of collected samples per age group}
#'   \item{n_seropositive}{Number of positive samples per age group}
#'   \item{age_min}{Age group minimal age}
#'   \item{age_max}{Age group maximal age}
#' }
#'
#' @keywords datasets
#'
#' @examples
#' data(veev2012)
"veev2012"
