% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STBP.R
\name{stbp_posterior_simple}
\alias{stbp_posterior_simple}
\title{Posterior calculation for simple hypotheses about species absence}
\usage{
stbp_posterior_simple(
  data,
  density_func,
  overdispersion = NA,
  prior,
  upper_bnd = Inf
)
}
\arguments{
\item{data}{For count data, a numeric vector with for a single sampling bout
(NAs allowed). For binomial data, a matrix with observations in col 1 and
samples in col 2 (NAs \emph{not} allowed).}

\item{density_func}{Kernel probability density function for the data. See details.}

\item{overdispersion}{A character string (if a function) or a number
specifying the overdispersion parameter. Only required when using
\code{"negative binomial"} or \code{"beta-binomial"} as kernel densities.
See details.}

\item{prior}{Single number with initial prior. Must be in the interval \eqn{[0,1]}.}

\item{upper_bnd}{Single number indicating the greatest possible value for \eqn{\mu}.
For count data, is often \code{Inf} (default), but it must be \eqn{\leq 1} for
binomial data.}
}
\value{
A single probability
}
\description{
This function calculates a posterior probability for hypotheses about population
densities, of the form \eqn{H:\mu = 0}, given the data at a single
iteration. This function is to be used in a sequential framework, and called
on the sequential test \code{\link{stbp_simple}}.
}
\details{
The \code{density_func} argument should be specified as character string.
Acceptable options are \code{"poisson"}, \code{"negative binomial"},
\code{"binomial"} and \code{"beta-binomial"}. The overdispersion
parameter for \code{"negative binomial"} and \code{"beta-binomial"} can be
either a constant or a function of the mean. If a function, it should be
specified as a character string with the name of an existing function. For
options of empirical functions to describe overdispersion as a function of
the mean see Binns et al. (2000). The most common approach for the negative
binomial family is Taylor's Power Law.
}
\examples{
# Counts collected in a single sampling bout
counts <- c(0, 0, 0)

# Calculate posterior probability from a naive 0.5 prior for H:mu=0
# (a species being absent in an area) with a poisson kernel.

stbp_posterior_simple(data = counts,
                       density_func = "poisson",
                       prior = 0.5,
                       upper_bnd = Inf) # returns 0.75
## End (Not run)
}
\references{
Binns, M.R., Nyrop, J.P. & Werf, W.v.d. (2000) \emph{Sampling and
monitoring in crop protection: the theoretical basis for developing practical
decision guides}. CABI Pub., Wallingford, Oxon, UK; New York, N.Y.

Rincon, D.F., McCabe, I. & Crowder, D.W. (2025) Sequential testing of
complementary hypotheses about population density. \emph{Methods in Ecology
and Evolution}. <https://doi.org/10.1111/2041-210X.70053>
}
