% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emotion.R
\name{plot.emotion}
\alias{plot.emotion}
\title{Plots a emotion object}
\usage{
\method{plot}{emotion}(
  x,
  transformation.function = syuzhet::get_dct_transform,
  drop.unused.emotions = TRUE,
  facet = TRUE,
  ...
)
}
\arguments{
\item{x}{The emotion object.}

\item{transformation.function}{A transformation function to smooth the emotion
scores.}

\item{drop.unused.emotions}{logical.  If \code{TRUE} unused/unfound emotion
levels will not be included in the output.}

\item{facet}{logical or one of \code{c('emotion', 'negated')}.  If \code{TRUE} 
or \code{'emotion'} the plot will be facetted by Emotion Type.  If \code{FALSE} 
all types will be plotted in the same window.  If \code{"negated"} the emotions
will be in the same plot window but broken out by negated or non-negated types.}

\item{\ldots}{Other arguments passed to \code{\link[syuzhet]{get_transformed_values}}.}
}
\value{
Returns a \pkg{ggplot2} object.
}
\description{
Plots a emotion object.
}
\details{
Utilizes Matthew Jocker's \pkg{syuzhet} package to calculate smoothed
emotion across the duration of the text.
}
