% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emotion_by.R
\name{emotion_by}
\alias{emotion_by}
\title{Emotion Rate By Groups}
\usage{
emotion_by(text.var, by = NULL, group.names, ...)
}
\arguments{
\item{text.var}{The text variable.  Also takes a \code{emotionr} or
\code{emotion_by} object.}

\item{by}{The grouping variable(s).  Default \code{NULL} uses the original
row/element indices; if you used a column of 12 rows for \code{text.var}
these 12 rows will be used as the grouping variable.  Also takes a single
grouping variable or a list of 1 or more grouping variables.}

\item{group.names}{A vector of names that corresponds to group.  Generally
for internal use.}

\item{\ldots}{Other arguments passed to \code{\link[sentimentr]{emotion}}.}
}
\value{
Returns a \pkg{data.table} with grouping variables plus:
\itemize{
  \item  element_id - The id number of the original vector passed to \code{emotion}
  \item  sentence_id - The id number of the sentences within each \code{element_id}
  \item  word_count - Word count \code{\link[base]{sum}}med by grouping variable
  \item emotion_type - Type designation from the \code{emotion} column of the \code{emotion_dt} table
  \item  emotion_count - The number of profanities used by grouping variable
  \item  sd - Standard deviation (\code{\link[stats]{sd}}) of the sentence level emotion rate by grouping variable
  \item  ave_emotion - Emotion rate
}
}
\description{
Approximate the emotion of text by grouping variable(s).  For a
full description of the emotion detection algorithm see 
\code{\link[sentimentr]{emotion}}.  See \code{\link[sentimentr]{emotion}}
for more details about the algorithm, the emotion/valence shifter keys
that can be passed into the function, and other arguments that can be passed.
}
\section{Chaining}{

See the  \code{\link[sentimentr]{sentiment_by}} for details about \pkg{sentimentr} chaining.
}

\examples{
\dontrun{
mytext <- c(
    "I am not afraid of you",
    NA,
    "",
    "I love it [not really]", 
    "I'm not angry with you", 
    "I hate it when you lie to me.  It's so humiliating",
    "I'm not happpy anymore.  It's time to end it",
    "She's a darn good friend to me",
    "I went to the terrible store",
    "There is hate and love in each of us",
    "I'm no longer angry!  I'm really experiencing peace but not true joy.",
    
    paste("Out of the night that covers me, Black as the Pit from pole to", 
      "pole, I thank whatever gods may be For my unconquerable soul.",
      "In the fell clutch of circumstance I have not winced nor cried",
      "aloud. Under the bludgeonings of chance My head is bloody, but unbowed.",
      "Beyond this place of wrath and tears Looms but the Horror of the", 
      "shade, And yet the menace of the years Finds, and shall find, me unafraid.",
      "It matters not how strait the gate, How charged with punishments", 
      "the scroll, I am the master of my fate: I am the captain of my soul."
    )    
    
)

## works on a character vector but not the preferred method avoiding the 
## repeated cost of doing sentence boundary disambiguation every time 
## `emotion` is run
emotion(mytext)
emotion_by(mytext)

## preferred method avoiding paying the cost 
mytext <- get_sentences(mytext)

emotion_by(mytext)
get_sentences(emotion_by(mytext))

(myemotion <- emotion_by(mytext))
stats::setNames(get_sentences(emotion_by(mytext)),
    round(myemotion[["ave_emotion"]], 3))

pres <- get_sentences(presidential_debates_2012)
pres_emo_sent <- emotion_by(pres)

## method 1
pres_emo_per_time <- presidential_debates_2012 \%>\%
    get_sentences() \%>\%
    emotion_by(by = c('person', 'time'))
    
pres_emo_per_time

## method 2
library(magrittr)
presidential_debates_2012 \%>\%
    get_sentences() \%$\%
    emotion_by(., by = c('person', 'time'))

## method 3
presidential_debates_2012 \%>\%
    get_sentences() \%$\%
    emotion_by(dialogue, by = list(person, time))

## method 4
presidential_debates_2012 \%>\%
    get_sentences() \%>\%
    with(emotion_by(dialogue, by = list(person, time)))

plot(pres_emo_sent)
plot(pres_emo_per_time)
}
}
\seealso{
Other emotion functions: 
\code{\link{emotion}()}
}
\concept{emotion functions}
\keyword{emotion}
