% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_app_details.R
\name{st_app_details}
\alias{st_app_details}
\title{Fetch Detailed App Metadata}
\usage{
st_app_details(
  app_ids,
  os,
  include_developer_contacts = TRUE,
  auth_token = NULL
)
}
\arguments{
\item{app_ids}{Character vector. App IDs to fetch details for. 
- For iOS: numeric app IDs (e.g., "553834731")
- For Android: bundle IDs (e.g., "com.king.candycrushsaga")
- For unified: unified app IDs
Maximum 100 apps per request.}

\item{os}{Character string. Required. Operating system: "ios", "android", or "unified".}

\item{include_developer_contacts}{Logical. Include developer contact information
(email, address). Defaults to TRUE.}

\item{auth_token}{Character string. Sensor Tower API authentication token.
Defaults to environment variable SENSORTOWER_AUTH_TOKEN.}
}
\value{
A [tibble][tibble::tibble] containing detailed app metadata with columns:
  - `app_id`: The app's store ID
  - `app_name`: The app's display name
  - `publisher_name`: Publisher/developer name
  - `publisher_id`: Publisher ID
  - `categories`: App store categories
  - `description`: Full app description
  - `subtitle`: App subtitle (iOS) or short description (Android)
  - `rating`: Current average rating
  - `rating_count`: Total number of ratings
  - `rating_current_version`: Rating for current version
  - `rating_count_current_version`: Rating count for current version
  - `content_rating`: Age rating/content rating
  - `price`: App price
  - `currency`: Price currency
  - `release_date`: Initial release date
  - `last_update`: Last update date
  - `version`: Current version
  - `size_bytes`: App size in bytes
  - `screenshots`: List of screenshot URLs
  - `icon_url`: App icon URL
  - `publisher_email`: Developer email (if include_developer_contacts = TRUE)
  - `publisher_address`: Developer address (if include_developer_contacts = TRUE)
  - `publisher_country`: Developer country
  - Additional platform-specific fields
}
\description{
Retrieves comprehensive metadata for one or more apps including descriptions,
screenshots, ratings, publisher information, and more. This function provides
rich app store listing data for apps when you already know their IDs.
}
\section{API Endpoint Used}{

  - `GET /v1/\{os\}/apps`
}

\examples{
\dontrun{
# Get details for a single iOS app
candy_crush <- st_app_details(
  app_ids = "553834731",
  os = "ios"
)

# Get details for multiple Android apps
android_games <- st_app_details(
  app_ids = c("com.king.candycrushsaga", "com.supercell.clashofclans"),
  os = "android"
)

# Get details without developer contacts
apps <- st_app_details(
  app_ids = c("553834731", "1053012308"),
  include_developer_contacts = FALSE
)
}

}
