% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivityIxJ.R
\name{generic.I.by.J.sensitivity.point.probability}
\alias{generic.I.by.J.sensitivity.point.probability}
\title{Compute the exact Probability of a Single Table for the Generic Bias Model}
\usage{
generic.I.by.J.sensitivity.point.probability(
  table,
  row = "treatment",
  u_allocation,
  gamma,
  delta,
  shared_divisor = 1e+06
)
}
\arguments{
\item{table}{A matrix or table object representing the observed contingency table.}

\item{row}{A string indicating whether rows represent "outcome" or "treatment".
Must be either "outcome" or "treatment". Default is "treatment".}

\item{u_allocation}{A vector where each entry represents the number of \code{u_i=1} in an outcome level. The first entry
represents the number of \code{u_i=1} among the subjects with outcome as one.}

\item{gamma}{A scalar}

\item{delta}{A binary vector with no more than two unique values, corresponding to treatment levels.
The length must match the number of treatments (rows of \code{obs.table} if \code{row = "treatment"},
or columns if \code{row = "outcome"}).}

\item{shared_divisor}{A scalar to rescale the numerator and the denominator of the probability mass function to prevent
overflow. Defaulted to 1000000.}
}
\value{
This function returns the probability mass of this table given a unmeasured confounder.
}
\description{
This function computes the probability of a single contingency table under the generic bias model given
an unmeasured confounder. This is an auxiliary function for the p-value computation.
}
