% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/senser.R
\name{senser}
\alias{senser}
\title{Proxy Indicator Diagnostic Tool}
\usage{
senser(
  data,
  proxy,
  target,
  lang = c("english", "indonesia"),
  stagnation_cut = 0.01,
  cv_cut = 0.02,
  ceiling_cut = 0.95
)
}
\arguments{
\item{data}{A data.frame containing the target construct and proxy variables.}

\item{proxy}{Character vector specifying one or more proxy variable names contained
in \code{data}.}

\item{target}{Character string specifying the target construct variable name contained
in \code{data}.}

\item{lang}{Language for status labels and interpretation text.
Must be either \code{"english"} or \code{"indonesia"}.}

\item{stagnation_cut}{Threshold used to detect stagnation (very small average absolute change).
Default is \code{0.01}.}

\item{cv_cut}{Threshold for the coefficient of variation (CV).
Default is \code{0.02}.}

\item{ceiling_cut}{Threshold used to detect ceiling effects.
Default is \code{0.95}.}
}
\value{
A data.frame with one row per proxy variable containing:

\describe{
\item{target}{Target construct name.}
\item{proxy}{Proxy variable name.}
\item{monotonicity}{Spearman correlation (absolute).}
\item{information_content}{R-squared value.}
\item{elasticity}{Elasticity index.}
\item{cv}{Coefficient of variation.}
\item{avg_change}{Average absolute change.}
\item{ceiling_ratio}{Mean-to-maximum ratio.}
\item{stability_score}{Coefficient stability index.}
\item{final_score}{Median diagnostic score.}
\item{classification}{Qualitative proxy category.}
\item{interpretation}{Plain-language interpretation.}
}
}
\description{
\code{senser()} is a statistical diagnostic function designed to evaluate
whether one or more proxy indicators are suitable representations of an
underlying construct that cannot be directly observed or measured.

The function assesses each proxy based on multiple statistical dimensions:
monotonicity, information content, stability, distributional alignment,
bias risk, and dynamic range (sensitivity).

The output is returned as a structured data.frame containing quantitative
scores and qualitative classifications suitable for applied research and
policy diagnostics.
}
\details{
The diagnostic score for each proxy is computed using six normalized components:

\itemize{
\item \strong{monotonicity}: Spearman rank correlation.
\item \strong{information_content}: R-squared from linear regression.
\item \strong{elasticity_score}: Responsiveness index.
\item \strong{variability_score}: Based on coefficient of variation.
\item \strong{stagnation_score}: Penalizes near-flat dynamics.
\item \strong{ceiling_score}: Penalizes ceiling effects.
\item \strong{stability_score}: Coefficient stability across subsamples.
}

The final proxy score is computed as the median of all components.

Classification categories:

\itemize{
\item Score >= 0.70: Suitable proxy
\item 0.40 <= Score < 0.70: Conditionally suitable
\item Score < 0.40: Not suitable proxy
}
}
\examples{
set.seed(123)
df <- data.frame(
  gdp = rnorm(100, 10, 2),
  ntl = rnorm(100, 50, 10),
  road_density = rnorm(100, 3, 0.5)
)

senser(
  data = df,
  proxy = c("ntl", "road_density"),
  target = "gdp",
  lang = "english"
)

}
\references{
Spearman, C. (1904). The proof and measurement of association between two things.
\emph{American Journal of Psychology}, 15(1), 72–101.

Chow, G. C. (1960). Tests of equality between sets of coefficients
in two linear regressions. \emph{Econometrica}.

OECD (2008). Handbook on Constructing Composite Indicators:
Methodology and User Guide.
}
\seealso{
\code{\link{lm}}, \code{\link{cor}}, \code{\link{median}}
}
\author{
Joko Nursiyono
}
