% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_curve.R
\name{set_curve}
\alias{set_curve}
\title{Bend or Straighten Selected edges}
\usage{
set_curve(semPaths_plot, curve_list = NULL)
}
\arguments{
\item{semPaths_plot}{A \link[qgraph:qgraph]{qgraph::qgraph} object generated by
\link[semPlot:semPaths]{semPlot::semPaths}, or a similar qgraph object modified by other
\link{semptools} functions.}

\item{curve_list}{A named vector or a list of named list. For a
named vector, the name of an element should be the path as
specified by \link[lavaan:model.syntax]{lavaan::model.syntax} or as appeared in
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}. For example, to change the curve
attribute of the path regressing \code{y} on \code{x}, the name should be
\code{"y ~ x"}. To change the curve attribute of the covariance between \code{x1}
and \code{x2}, the name should be \code{"x1 ~~ x2"}. For example,
\code{c("y ~ x1" = -3, "x1 ~~ x2" = 2)} change the curve attributes of
the path from \code{x1} to \code{y} and the covariance between \code{x1} and \code{x2}
to -3 and 2, respectively. The order of the two nodes \emph{may} matter
for covariances. Therefore, if the curve of a covariance is not
changed, try switching the order of the two nodes. For a list of
named lists, each named list should have three named values:
\code{from}, \code{to}, and \code{new_curve}. The curve attribute of the edge from
\code{from} to \code{to} will be set to \code{new_curve}.}
}
\value{
A \link[qgraph:qgraph]{qgraph::qgraph} based on the original one, with curve
attributes for selected edges changed.
}
\description{
Set the curve attributes of selected edges.
}
\details{
Modified a \link[qgraph:qgraph]{qgraph::qgraph} object generated by
\link[semPlot:semPaths]{semPlot::semPaths} and change the curve attributes of selected
edges.
}
\examples{
mod_pa <-
 'x1 ~~ x2
  x3 ~  x1 + x2
  x4 ~  x1 + x3
 '
fit_pa <- lavaan::sem(mod_pa, pa_example)
lavaan::parameterEstimates(fit_pa)[, c("lhs", "op", "rhs", "est", "pvalue")]
m <- matrix(c("x1",   NA,   NA,
               NA, "x3", "x4",
             "x2",   NA,   NA), byrow = TRUE, 3, 3)
p_pa <- semPlot::semPaths(fit_pa, whatLabels="est",
           style = "ram",
           nCharNodes = 0, nCharEdges = 0,
           layout = m)

my_curve_vector <- c("x2 ~~ x1" = -1,
                    "x4 ~ x1" = 1)

p_pa2v <- set_curve(p_pa, my_curve_vector)
plot(p_pa2v)

my_curve_list <- list(list(from = "x1", to = "x2", new_curve = -1),
                    list(from = "x1", to = "x4", new_curve =  1))

p_pa2l <- set_curve(p_pa, my_curve_list)
plot(p_pa2l)

}
