% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_node.R
\name{move_node}
\alias{move_node}
\title{Move Nodes in a Plot}
\usage{
move_node(semPaths_plot, move_by = NULL)
}
\arguments{
\item{semPaths_plot}{A
\link[qgraph:qgraph]{qgraph::qgraph} object generated by
\link[semPlot:semPaths]{semPlot::semPaths}, or a similar
qgraph object modified by other
\link{semptools} functions.}

\item{move_by}{A named list. The
names are the names of nodes to be
moved. Each element of the list can
be either a named numeric vector or
an unnamed vector of two numbers. If
a named vector, \code{x} is the horizontal
change in the position (e.g., .25
means moving to the right by .25, and
-.5 means moving to the left by .5),
and \code{y} is the vertical change (e.g.,
.5 means moving up by .5, and -.1
means moving down by .1). If unnamed,
then the vector must have two numbers,
the first for the horizontal move (\code{x})
and the second for the vertical move.
The value is interpreted based on
the unit of the plot, usually from
-1 to 1 for \code{x} and \code{y}, with 0 being
the center of the plot.}
}
\value{
A \link[qgraph:qgraph]{qgraph::qgraph} based on
the original one, with the selected
nodes moved.
}
\description{
Move the nodes in an
plot generated by \code{\link[semPlot:semPaths]{semPlot::semPaths()}}.
}
\details{
Modify a \link[qgraph:qgraph]{qgraph::qgraph}
object generated by
\link[semPlot:semPaths]{semPlot::semPaths} and move selected
nodes.

The change assumes that the layout
is defined with 0 as the center,
-1 to 1 from left to right, and
from bottom to top.
}
\examples{
mod_pa <-
  'x1 ~~ x2
   x3 ~  x1 + x2
   x4 ~  x1 + x3
  '
fit_pa <- lavaan::sem(mod_pa, pa_example)
lavaan::parameterEstimates(fit_pa)[, c("lhs", "op", "rhs", "est", "pvalue")]
m <- matrix(c("x1",   NA,   NA,
                NA, "x3", "x4",
              "x2",   NA,   NA), byrow = TRUE, 3, 3)
p_pa <- semPlot::semPaths(fit_pa, whatLabels="est",
            style = "ram",
            nCharNodes = 0, nCharEdges = 0,
            layout = m)

p_changed <- move_node(p_pa,
                       list(x3 = c(x = -.25, y = -.25),
                            x4 = c(y = .5)))
plot(p_changed)

}
