% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gorica.R
\name{goricaSEM}
\alias{goricaSEM}
\title{Wrapper for \code{goric.lavaan()} from the \code{restriktor} package}
\usage{
goricaSEM(object, ..., hypotheses = NULL, comparison = NULL,
  type = "gorica", standardized = FALSE, debug = FALSE)
}
\arguments{
\item{object}{A \link[lavaan:lavaan-class]{lavaan::lavaan} object.}

\item{...}{Additional arguments passed to \code{\link[restriktor:goric]{restriktor::goric.lavaan()}}.}

\item{hypotheses}{A named \code{list} of hypotheses to test. See \strong{Details} for
information on how to specify hypotheses.}

\item{comparison}{A \code{character} string specifying the type of comparison.
Options are \code{"unconstrained"}, \code{"complement"}, or \code{"none"}.
Default behavior depends on the number of hypotheses.}

\item{type}{A \code{character} string indicating the type of analysis, either
\code{"gorica"} (default) or \code{"goricac"}.}

\item{standardized}{\code{logical} indicating whether standardized estimates are
used in the analysis. Defaults to \code{FALSE}.}

\item{debug}{\code{logical} indicating whether to print debugging information.
Defaults to \code{FALSE}.}
}
\value{
A \code{list} containing the results of the \code{goric.lavaan} function,
including:
\itemize{
\item The log-likelihood.
\item Penalty term.
\item GORIC(A) values and weights.
\item Relative GORIC(A) weights.
}
}
\description{
The \code{goricaSEM()} function is an interface to \code{\link[restriktor:goric]{restriktor::goric.lavaan()}},
allowing users to perform generalized order-restricted information criterion
approximation (GORICA) analysis specifically for structural equation
models fitted using the \pkg{lavaan} package.
}
\details{
This function is designed as a wrapper for the \code{\link[restriktor:goric]{restriktor::goric.lavaan()}}
function. It calculates GORICA values and weights, which can be used to
compare models or hypotheses under inequality constraints.

The \verb{hypotheses=} argument allows users to specify constraints in text-based
syntax or matrix notation. For text-based syntax, constraints are specified
as a string (e.g., \code{"a1 > a2"}). For matrix notation, a named list with
\verb{$constraints}, \verb{$rhs}, and \verb{$neq} elements can be provided.

The \verb{comparison=} argument determines whether the specified hypothesis is
compared against its \code{"complement"}, the \code{"unconstrained"} model, or
neither (\code{"none"}).
}
\examples{

## Example: Perform GORICA analysis on a lavaan model
library(lavaan)
library(restriktor)

## Define the SEM model
model <- '
  ind60 =~ x1 + x2 + x3
  dem60 =~ y1 + a1*y2 + b1*y3 + c1*y4
  dem65 =~ y5 + a2*y6 + b2*y7 + c2*y8
  dem60 ~ ind60
  dem65 ~ ind60 + dem60
  y1 ~~ y5
  y2 ~~ y4 + y6
  y3 ~~ y7
  y4 ~~ y8
  y6 ~~ y8
'

## Fit the model
data(PoliticalDemocracy)
fit <- sem(model, data = PoliticalDemocracy)

## Define hypotheses
myHypothesis <- 'a1 > a2, b1 > b2, c1 > c2'

## Perform GORICA analysis
result <- goricaSEM(fit, hypotheses = list(H1 = myHypothesis),
                    standardized = FALSE, comparison = "complement",
                    type = "gorica")

## Print result
print(result)

}
\references{
Kuiper, R. M., Hoijtink, H., & Silvapulle, M. J. (2011). An Akaike-type
information criterion for model selection under inequality constraints.
\emph{Biometrika, 98}(2), 495--501. \doi{10.1093/biomet/asr002}

Vanbrabant, L., Van Loey, N., & Kuiper, R. M. (2020). Evaluating a
theory-based hypothesis against its complement using an AIC-type
information criterion with an application to facial burn injury.
\emph{Psychological Methods, 25}(2), 129--142. \doi{10.1037/met0000238}
}
\seealso{
\code{\link[restriktor:goric]{restriktor::goric.lavaan()}}
}
\author{
Leonard Vanbrabant and Rebecca Kuiper
}
