% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_indices.R
\name{lgsi}
\alias{lgsi}
\title{Linear Genomic Selection Index (LGSI)}
\usage{
lgsi(
  gebv_mat,
  gmat,
  wmat,
  wcol = 1,
  reliability = NULL,
  selection_intensity = 2.063,
  GAY = NULL
)
}
\arguments{
\item{gebv_mat}{Matrix of GEBVs (n_genotypes x n_traits)}

\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits)}

\item{wmat}{Economic weights matrix (n_traits x k), or vector}

\item{wcol}{Weight column to use if wmat has multiple columns (default: 1)}

\item{reliability}{Optional. Reliability of GEBVs (correlation between GEBV and true BV).
Can be:
- Single value (applied to all traits)
- Vector of length n_traits (one per trait)
- NULL (default): estimated from GEBV variance (assumes reliability = GEBV_var / G_var)}

\item{selection_intensity}{Selection intensity i (default: 2.063 for 10\% selection)}

\item{GAY}{Optional. Genetic advance of comparative trait for PRE calculation}
}
\value{
List with components:
  \itemize{
    \item \code{b} - Index coefficients
    \item \code{P_gebv} - GEBV variance-covariance matrix
    \item \code{reliability} - Reliability values used
    \item \code{Delta_H} - Expected genetic advance per trait
    \item \code{GA} - Overall genetic advance in the index
    \item \code{PRE} - Percent relative efficiency (if GAY provided)
    \item \code{hI2} - Index heritability
    \item \code{rHI} - Index accuracy
    \item \code{sigma_I} - Standard deviation of the index
    \item \code{summary} - Data frame with all metrics
  }
}
\description{
Implements the Linear Genomic Selection Index where selection is based solely on
Genomic Estimated Breeding Values (GEBVs). This is used for selecting candidates
that have been genotyped but not phenotyped (e.g., in a testing population).
}
\details{
\strong{Mathematical Formulation:}

The LGSI maximizes the correlation between the index I = b' * gebv and

Index coefficients: \eqn{\mathbf{b} = \mathbf{P}_{\hat{g}}^{-1} \mathbf{C}_{\hat{g}g} \mathbf{w}}

Where:
- \eqn{\mathbf{P}_{\hat{g}}} = Var(gebv) - variance-covariance of GEBVs
- \eqn{\mathbf{C}_{\hat{g}g}} = Cov(gebv, g) - covariance between GEBVs and true breeding values

If reliability (r) is known: \eqn{\mathbf{C}_{\hat{g}g} = \text{diag}(r) \mathbf{P}_{\hat{g}}}

Expected response: \eqn{\Delta \mathbf{H} = \frac{i}{\sigma_I} \mathbf{C}_{\hat{g}g} \mathbf{b}}
}
\examples{
\dontrun{
# Generate example data
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])

# Simulate GEBVs (in practice, these come from genomic prediction)
set.seed(123)
n_genotypes <- 100
n_traits <- ncol(gmat)
gebv_mat <- matrix(rnorm(n_genotypes * n_traits, mean = 10, sd = 2),
  nrow = n_genotypes, ncol = n_traits
)
colnames(gebv_mat) <- colnames(gmat)

# Economic weights
weights <- c(10, 5, 3, 3, 5, 8, 4)

# Calculate LGSI
result <- lgsi(gebv_mat, gmat, weights, reliability = 0.7)
print(result$summary)
}
}
\references{
Cerón-Rojas, J. J., & Crossa, J. (2018). Linear Selection Indices in Modern Plant Breeding.
Springer International Publishing.
}
