% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phystiodata.R
\name{physiodata}
\alias{physiodata}
\title{Transforms dataset to physiodata format}
\usage{
physiodata(d, t = "times", g = "germinated", pg = "germinable", x =
  "treatment", groups = NULL)
}
\arguments{
\item{d}{a data.frame containing the results of a germination experiment. The
data frame should include columns with scoring times, germination counts
(not cumulative), number of potentially germinable seeds, and the
environmental variable of interest. (e.g. temperature or water potential)
(see \code{\link{grasses}} example dataset for appropriate structure).}

\item{t}{the name of a column in \code{d} containing a vector of numeric
scoring times.}

\item{g}{the name of a column in \code{d} containing a vector of integer
germination counts (non cumulative).}

\item{pg}{the name of a column in \code{d} containing a vector of integer
numbers of potentially germinable seeds.}

\item{x}{the name of a column in \code{d} containing a vector of numeric
values for the environmental variable of interest (e.g. temperature, water
potential).}

\item{groups}{optional, the names of columns in \code{d} containing grouping
variables for the experiment that have to be analysed separately (e.g.
different species or populations, different temperatures in a water
potential experiment, different treatments to break seed dormancy).}
}
\value{
\code{physiodata} returns a S3 object of class "physiodata". The
  object is a list containing, for each group, treatment and scoring time:
  the cumulative germination count; the cumulative germination proportion;
  and the lower and upper bounds of the 95 % binomial confidence interval,
  calculated with the Wilson method as implemented in the package
  \code{binom}. The object can be used to explore the data using the generic
  functions \code{summary}, \code{barplot} and \code{plot}.
}
\description{
\code{physiodata} takes the user's dataset and transforms it to an object of
class "physiodata". This object will be used by the model-fitting functions,
and it can also be used to explore the data.
}
\examples{
cent <- physiodata(centaury, x = "temperature")
cent
summary(cent) # average final germination proportions and germination rates per treatment
barplot(cent) # bar plots for the final germination proportions and germination rates
plot(cent) # cumulative germination curves
physiodata(grasses, x = "psi", groups = "species") # grouping dataset by species
}
