% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roche_utils.R
\name{roche_derive_rave_row}
\alias{roche_derive_rave_row}
\title{Utility function to obtain Rave form name and row number}
\usage{
roche_derive_rave_row(
  dts,
  domains = c("ae", "ce", "cm", "ds", "lb", "mh", "pr", "rs", "ss", "tr", "tu")
)
}
\arguments{
\item{dts}{SDTM dataframe - e.g., AE}

\item{domains}{domains you wish to identify a xxSPID variable from}
}
\value{
dataframe with Rave row number
}
\description{
This function derives the Rave form name and row number from xxSPID.
The xxSPID string may yield unexpected results for outsourced studies. Log forms
will show the row number as #n. Non-log forms may show #0 after the form name.
}
\examples{

AE <- data.frame(
  STUDY = c(rep("1", 6)),
  DOMAIN = c(rep("AE", 6)),
  USUBJID = c(rep("PT1", 6)),
  AESEQ = c(1, 2, 3, 4, 5, 6),
  AETERM = rep("AE Raw Term",6),
  AEDECOD = rep("AE Preferred Term",6),
  AESPID = c("FORMNAME-R:13/L:13XXXX",
             "FORMNAME-R:16/L:16XXXX",
             "FORMNAME-R:2/L:2XXXX",
             "FORMNAME-R:19/L:19XXXX",
             "FORMNAME-R:5/L:5XXXX",
             "FORMNAME-R:20/L:20XXXX"),
  AESTDTC = c(rep("2020-01-01", 6)),
  stringsAsFactors = FALSE
)

roche_derive_rave_row(AE)

}
\author{
Stella Banjo (HackR 2021)
}
\keyword{internal}
