% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_R_script}
\alias{create_R_script}
\title{Create .R file with sdtmchecks function calls}
\usage{
create_R_script(
  metads = sdtmchecksmeta,
  file = "sdtmchecks_run_all.R",
  verbose = TRUE
)
}
\arguments{
\item{metads}{sdtmchecksmeta file}

\item{file}{filename and/or path to save to}

\item{verbose}{Print information to console}
}
\value{
R script with user specified sdtmchecks based on sdtmchecksmeta file
}
\description{
Function that uses sdtmchecksmeta as input and creates .R file with function calls
}
\examples{


# All checks are output to a file
fileName <- file.path(tempdir(), "run_all_checks.R")
create_R_script(file = fileName)

# Only include selected checks
fileName <- file.path(tempdir(), "run_some_checks.R")
mymetads = sdtmchecksmeta[sdtmchecksmeta$category == "ALL" & sdtmchecksmeta$priority == "High",]
create_R_script(metads = mymetads, file = fileName)

# Roche specific function calls
fileName <- file.path(tempdir(), "run_all_checks_roche.R")
mymetads = sdtmchecksmeta
mymetads$fxn_in=mymetads$fxn_in_roche
create_R_script(metads = mymetads, file = fileName)

}
\seealso{
Reporting-related utility functions
\code{\link{convert_var_to_ascii}()},
\code{\link{truncate_var_strings}()}
}
\author{
Monarch Shah
}
\concept{utils_rpt}
\keyword{utils_rpt}
