% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_tu_rs_new_lesions.R
\name{check_tu_rs_new_lesions}
\alias{check_tu_rs_new_lesions}
\title{Check for consistency between new lesions and overall PD response}
\usage{
check_tu_rs_new_lesions(RS, TU)
}
\arguments{
\item{RS}{Response SDTM dataset with variables USUBJID, RSSTRESC, RSTESTCD}

\item{TU}{Tumor Identification SDTM dataset with variables USUBJID, TUSTRESC,
TUDTC}
}
\value{
TRUE if check passed and FALSE if check failed + 'msg' and 'data'
attributes
}
\description{
This checks for patients with new lesions in TU (TUSTRESC=='NEW')
but no Overall Response assessment of PD (Disease Progression) or
PMD (Progressive Metabolic Disease) in RS (i.e., (RSTESTCD=='OVRLRESP' and
RSSTRESC \%in\% c('PD','PMD'))). Only applies to assessments by investigator,
if TUEVAL and RSEVAL variables available.
}
\examples{

TU <- data.frame(
 USUBJID = 1:3,
 TUSTRESC = c("INV001","NEW","NEW"),
 TUDTC = "2017-01-01"
)

RS <- data.frame(
 USUBJID = 1:2,
 RSSTRESC = c("SD","NE")
)

# required variable is missing 
check_tu_rs_new_lesions(RS,TU)

RS$RSTESTCD = 'OVRLRESP'

# flag USUBJIDs with NEW 
check_tu_rs_new_lesions(RS,TU)


RS$RSSTRESC[2] = "PD"

# flag USUBJID with NEW and without PD
check_tu_rs_new_lesions(RS,TU)
   
# Metabolic response in heme trials
RS$RSSTRESC[2] = "PMD"
check_tu_rs_new_lesions(RS,TU)


# pass when USUBJIDs with new have PD
RS <- data.frame(
 USUBJID = 1:3,
 RSSTRESC = c("SD","PD", "PD"), 
 RSTESTCD = "OVRLRESP"
)

check_tu_rs_new_lesions(RS,TU)

TU$TUEVAL = "INDEPENDENT ASSESSOR"

RS$RSEVAL = "INDEPENDENT ASSESSOR"

## pass if by IRF, even if NEW in TU
check_tu_rs_new_lesions(RS,TU)

RS <- NULL

# required dataset missing 
check_tu_rs_new_lesions(RS,TU)

}
\author{
Will Harris
}
