% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ss_ssstat_ssorres.R
\name{check_ss_ssstat_ssorres}
\alias{check_ss_ssstat_ssorres}
\title{Check for non-missing SSORRES if SSSTAT is NOT DONE}
\usage{
check_ss_ssstat_ssorres(SS, preproc = identity, ...)
}
\arguments{
\item{SS}{Long-Term Survival Follow-Up SDTM dataset with variables USUBJID,
VISIT, SSSTAT, SSDTC, SSORRES, SSSPID (optional)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check is for studies with LTFU mapped to the SS domain,
check that if 'NOT DONE' (Unable to Contact), then there should not be
a response (SSORRES)
}
\examples{

SS <- data.frame(
STUDYID = 1,
USUBJID = c(rep(1,6),rep(2,6)),
SSSTRESC = c("ALIVE", "DEAD", "ALIVE", "", "", "U"),
SSORRES = c("ALIVE", "DEAD", "ALIVE", "", "", "U"),
VISIT = rep(c("SURVIVAL FOLLOW UP 3 MONTHS"),6),
SSSTAT = rep(c("","NOT DONE"),6),
SSDTC = "2016-01-01",
SSSPID = "",
stringsAsFactors = FALSE
)

check_ss_ssstat_ssorres(SS)

SS$SSORRES[2]=NA
check_ss_ssstat_ssorres(SS)

SS$SSSPID="FORMNAME-R:5/L:5XXXX"
check_ss_ssstat_ssorres(SS,preproc=roche_derive_rave_row)

SS$SSORRES[6]=NA
SS$SSORRES[8]=""
SS$SSORRES[12]=NA
check_ss_ssstat_ssorres(SS)

SS$SSORRES=NULL
check_ss_ssstat_ssorres(SS)


}
\author{
Sara Bodach
}
