% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_rs_rsdtc_visit_ordinal_error.R
\name{check_rs_rsdtc_visit_ordinal_error}
\alias{check_rs_rsdtc_visit_ordinal_error}
\title{Check that all RS dates for INV Overall Response are duplicated or
earlier than last visit's (possible date entry error)}
\usage{
check_rs_rsdtc_visit_ordinal_error(RS)
}
\arguments{
\item{RS}{Response SDTM dataset with variables USUBJID, VISITNUM, VISIT,
RSDTC, RSTESTCD, RSEVAL, RSSTAT}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check identifies RSDTC values when RSEVAL == 'INVESTIGATOR'
and RSTESTCD == 'OVRLRESP' that are duplicated or earlier than last visit's.
Unscheduled and 'NOT DONE' visits are excluded.
}
\examples{

# no cases
RS<- data.frame(USUBJID = 101:102,
                RSDTC=rep(c("2017-01-01T08:25", "2017-01-05T09:25",
                       "2017-01-15T10:25","2017-01-20T08:25","2017-01-25T08:25"), 2),
                VISITNUM=rep(1:5,2),
                VISIT=rep(c("Screening", "Cycle 1", "Cycle 2","Cycle 3","Follow-up"),2),
                RSTESTCD="OVRLRESP",
                RSEVAL="INVESTIGATOR",
                RSSTAT="",
                stringsAsFactors=FALSE)
check_rs_rsdtc_visit_ordinal_error(RS)

# adding cases with earler date
RS$RSDTC[RS$USUBJID == 101 & RS$VISIT == "Cycle 3"] <- "2017-01-02T08:25"
RS$RSDTC[RS$USUBJID == 102 & RS$VISIT == "Cycle 1"] <- "2017-01-01T06:25"
check_rs_rsdtc_visit_ordinal_error(RS)

}
\author{
James Zhang
}
