% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_rs_rscat_rsscat.R
\name{check_rs_rscat_rsscat}
\alias{check_rs_rscat_rsscat}
\title{Check for patients with populated RSSCAT but missing RSCAT.}
\usage{
check_rs_rscat_rsscat(RS)
}
\arguments{
\item{RS}{Response SDTM dataset with variables USUBJID, RSCAT and RSSCAT.}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
Check for patients with populated RSSCAT but missing RSCAT in RS domain to
help flag a potential mapping issue for SPA; this does not warrant a query in Rave.
}
\examples{

RS <- data.frame(
 USUBJID = c("id1", "id1", "id2", "id2", "id3"),
 RSCAT = c("A", "A", "B", NA, NA),
 RSSCAT = c("AA", "AA", "BB", "BB","AA"))
check_rs_rscat_rsscat(RS)

# Test with missing RSCAT
RS$RSCAT = NULL
check_rs_rscat_rsscat(RS)

}
\author{
Saibah Chohan, Ashley Mao, Tina Cho (HackR 2021 Team STA-R)
}
