% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dm_age_missing.R
\name{check_dm_age_missing}
\alias{check_dm_age_missing}
\title{Check for patients with suspicious age values}
\usage{
check_dm_age_missing(DM)
}
\arguments{
\item{DM}{Demographics SDTM dataset with variables USUBJID,AGE}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
Check for patients with missing AGE, AGE<18 or AGE>90 in DM
}
\examples{

DM <- data.frame(
 USUBJID = 1:10,
 AGE = c(50,60,17,99,NA,33,500,40,22,NA)
)

check_dm_age_missing(DM)

DM$AGE = NULL

check_dm_age_missing(DM)

}
\author{
Nina Qi
}
