% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dm_actarm_arm.R
\name{check_dm_actarm_arm}
\alias{check_dm_actarm_arm}
\title{Check DM where ARM is not equal to ACTARM}
\usage{
check_dm_actarm_arm(DM)
}
\arguments{
\item{DM}{Demographics SDTM dataset with variables USUBJID, ARM, and ACTARM}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the check failed
}
\description{
This check looks for DM entries where ARM is not equal to ACTARM
}
\examples{

DM <- data.frame(USUBJID = 1:5,
                 ARM = c(letters[1:3], letters[5:6]),
                 ACTARM = letters[1:5],
                 stringsAsFactors = FALSE)

check_dm_actarm_arm(DM)

}
\author{
Ying Yuen
}
