% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_dup.R
\name{check_ae_dup}
\alias{check_ae_dup}
\title{Check for duplicate AE entries}
\usage{
check_ae_dup(AE)
}
\arguments{
\item{AE}{AE SDTM dataset with variables USUBJID, AETERM, AEDECOD,
AESTDTC, AEENDTC, and AETOXGR or AESEV}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
Identifies duplicated AE entries based on USUBJID, AETERM,
AEDECOD, AESTDTC, AEENDTC, AEMODIFY (if present), AELAT (if present) and AETOXGR or AESEV
}
\examples{

AE <- data.frame(USUBJID = c(1), AESTDTC = c("2020-01-01","2020-01-01","2020-02-01","2020-03-01"),
                 AEENDTC = rep("2020-02-01",4), AEDECOD = letters[c(1,1:3)],
                 AETERM = letters[c(1,1:3)], AETOXGR = c(1,1:3),
                 AESPID="FORMNAME-R:5/L:5XXXX",
                 stringsAsFactors=FALSE)

check_ae_dup(AE)



}
\author{
Edgar Manukyan
}
