% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aeacnoth.R
\name{check_ae_aeacnoth}
\alias{check_ae_aeacnoth}
\title{Check for null AEACNOT1/2 when AEACNOTH = 'MULTIPLE'}
\usage{
check_ae_aeacnoth(AE, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AETERM, AESTDTC,
AEACNOTH, AEACNOT1/2, AESPID (optional)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
Flag if patient has a record with null values of AEACNOT1 and AEACNOT2
but AEACNOTH = 'MULTIPLE', so a likely mapping issue
}
\examples{

AE <- data.frame(
 USUBJID = 1:7,
 AETERM = 1:7,
 AESTDTC = 1:7,
 AEACNOTH = 1:7,
 AEACNOT1 = 1:7,
 AEACNOT2 = 1:7,
 AESPID = "FORMNAME-R:13/L:13XXXX"
)

# pass
check_ae_aeacnoth(AE)

AE$AEACNOTH[1] = ""
AE$AEACNOT1[1] = ""
AE$AEACNOT2[1] = ""
AE$AEACNOTH[2] = "MULTIPLE"
AE$AEACNOT1[2] = "DOSE REDUCED"
AE$AEACNOT2[2] = "DRUG WITHDRAWN"
AE$AEACNOTH[3] = "MULTIPLE"
AE$AEACNOT1[3] = "DOSE REDUCED"
AE$AEACNOT2[3] = ""
AE$AEACNOTH[4] = "MULTIPLE"
AE$AEACNOT1[4] = ""
AE$AEACNOT2[4] = "DRUG WITHDRAWN"
AE$AEACNOTH[5] = "MULTIPLE"
AE$AEACNOT1[5] = ""
AE$AEACNOT2[5] = ""

# fail
check_ae_aeacnoth(AE)
check_ae_aeacnoth(AE,preproc=roche_derive_rave_row)

AE$AEACNOTH[1] = NA
AE$AEACNOT1[1] = NA
AE$AEACNOT2[1] = NA
AE$AEACNOT2[3] = NA 
AE$AEACNOT1[4] = NA 
AE$AEACNOT1[5] = NA
AE$AEACNOT2[5] = NA

# fail
check_ae_aeacnoth(AE)
check_ae_aeacnoth(AE,preproc=roche_derive_rave_row)


AE$AEACNOTH <- NULL
AE$AEACNOT1 <- NULL
AE$AEACNOT2 <- NULL
AE$AESPID <- NULL
check_ae_aeacnoth(AE)

}
\author{
Ross Farrugia
}
