% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran_test.R
\name{moran_test}
\alias{moran_test}
\title{global spatial autocorrelation test}
\usage{
moran_test(sfj, wt = NULL, alternative = "greater", symmetrize = FALSE)
}
\arguments{
\item{sfj}{An \code{sf} object or can be converted to \code{sf} by \code{sf::st_as_sf()}.}

\item{wt}{(optional) Spatial weight matrix. Must be a \code{matrix} class. If \code{wt} is not
provided, \code{sdsfun} will use a first-order queen adjacency binary matrix.}

\item{alternative}{(optional) Specification of alternative hypothesis as \code{greater} (default),
\code{lower}, or \code{two.sided}.}

\item{symmetrize}{(optional) Whether or not to symmetrize the asymmetrical spatial weight matrix
\emph{\strong{wt}} by: 1/2 * (\emph{\strong{wt}} + \emph{\strong{wt}}'). Default is \code{FALSE}.}
}
\value{
A list utilizing a \code{result} tibble to store the following information for each variable:
\describe{
\item{\code{MoranI}}{observed value of the Moran coefficient}
\item{\code{EI}}{expected value of Moran's I}
\item{\code{VarI}}{variance of Moran's I (under normality)}
\item{\code{ZI}}{standardized Moran coefficient}
\item{\code{PI}}{\emph{p}-value of the test statistic}
}
}
\description{
global spatial autocorrelation test
}
\examples{
gzma = sf::read_sf(system.file('extdata/gzma.gpkg',package = 'sdsfun'))
moran_test(gzma)

}
