% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{dist}
\alias{dist}
\title{Return the distance between two subspaces spanning by column space of matrices.}
\usage{
dist(A, B)
}
\arguments{
\item{A}{Matrix 1 with dimension p-by-d.}

\item{B}{Matrix 2 with dimension p-by-d.}
}
\value{
The outputs include three scales and one d-dimensional vector.
\item{r}{One minuse the summation of eiegenvalues of the matrix B^TAA^TB.}

\item{q}{One minues the product of eiegenvalues of the matrix B^TAA^TB.}

\item{rho}{rho=sqrt(A^TBB^TA)}

\item{m^2}{A d-variate vector giving the colum-wise distance between A and B.}
}
\description{
The function calculates three metrics for measuring the distance between two subspaces spaning by the columns of two matrices.
}
\references{
Samadi S. Y. and De Alwis T. P. (2023). Fourier Method of Estimating Time Series Central Mean Subspace.
\emph{https://arxiv.org/pdf/2312.02110}.

Ye Z. and Weiss R.E. (2003). Using the Bootstrap to Select One of a New Class of Dimension Reduction Methods,
\emph{Journal of the American Statistical Association}, 98,968-978.
}
