% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_background.R
\name{step_select_background}
\alias{step_select_background}
\alias{tidy.step_select_background}
\title{Feature selection step using background level}
\usage{
step_select_background(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  background_level = NULL,
  n_samples = NULL,
  prop_samples = NULL,
  res = NULL,
  skip = FALSE,
  id = rand_id("select_background")
)

\method{tidy}{step_select_background}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[recipes:selections]{recipes::selections()}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{background_level}{Background level to exceed.}

\item{n_samples, prop_samples}{Count or proportion of samples in which a
feature exceeds \code{background_level} to be retained.}

\item{res}{This parameter is only produced after the recipe has been trained.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_select_background} object.}
}
\value{
An updated version of recipe with the new step added to the
sequence of any existing operations.
}
\description{
Select features that exceed a background level in at least a defined
number of samples.
}
\examples{
rec <-
  iris \%>\%
  recipe(formula = Species ~ .) \%>\%
  step_select_background(all_numeric_predictors(),
                         background_level = 4, prop_samples = 0.5) \%>\%
  prep()
rec
tidy(rec, 1)
bake(rec, new_data = NULL)
}
\author{
Antoine Bichat
}
