% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_burn_probability.R
\name{flp20_to_raster}
\alias{flp20_to_raster}
\title{Convert processed FLP data to raster format and calculate conditional annual burn probability}
\usage{
flp20_to_raster(df, fl_threshold, selected_surf, reference_surface, r_ref)
}
\arguments{
\item{df}{A data frame processed by `flp20_to_df` or `flp20_to_bp_df`.}

\item{fl_threshold}{A numeric value representing the minimum flame length (FL).}

\item{selected_surf}{A data frame or list containing a `size` column.}

\item{reference_surface}{A numeric value representing a reference surface area.}

\item{r_ref}{A terra SpatRaster object.}
}
\value{
A list containing two raster objects: `CBP`, `CFL` and `ID_fires`.
}
\description{
Filters a data frame of fire data based on a flame length threshold,
groups by spatial position (`XPos`, `YPos`), and summarizes it into
conditional annual burning probability (CBP) estimates and
mean flame length (FL_mean).
}
