% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clampfit.R
\name{clampfit.read}
\alias{clampfit.read}
\title{Read a .xlsx file output from clampfit}
\usage{
clampfit.read(filename, separating_factor = 1000, header = FALSE)
}
\arguments{
\item{filename}{Filename to read from}

\item{separating_factor}{In lieu of a known time between segments, seperate with a multple of the longest dwell.}

\item{header}{Does the file include a header?}
}
\value{
A list of bursts (possibly a singleton)
}
\description{
Read a .xlsx file output from clampfit. Result is a list of "segments", which is a dataframe extra data. See "segment" for more details. Converts millisecond dwells to seconds.
}
\examples{

infile <- system.file("extdata", "example1_clampfit.xlsx", package = "scbursts")
dwells <- clampfit.read(infile)
head(dwells)

}
